/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.ICMP6Header;
import com.ibm.as400.util.commtrace.MTU;
import com.ibm.as400.util.commtrace.PrefixInfo;
import com.ibm.as400.util.commtrace.RedirectedHeader;
import com.ibm.as400.util.commtrace.SourceLLA;
import com.ibm.as400.util.commtrace.TargetLLA;

public abstract class NDOption
extends ICMP6Header {
    Field ndtype;
    Field length;
    public static final int SOURCELLA = 1;
    public static final int TARGETLLA = 2;
    public static final int PREFIXINFO = 3;
    public static final int REDIRECTED = 4;
    public static final int MTU = 5;
    static final String OPTDATA = "Option Data";
    static final String TYPE = "Type";
    static final String LEN = "Length";
    static final String ADDR = "Address";
    static final String PFXLEN = "PrefixLen";
    static final String PKT = "Packet";
    static final String VLDLIFETIME = "ValidLifeTime";
    static final String PRETIME = "PreferredTime";
    static final String PFX = "Prefix";
    static final String MTUSTR = "MTU";

    NDOption(BitBuf data) {
        super(data);
        this.ndtype = new Dec(this.rawheader.slice(0, 8));
        this.length = new Dec(this.rawheader.slice(8, 8));
    }

    static NDOption createNDOption(BitBuf b) {
        if (b.getBitSize() == 0) {
            return null;
        }
        int ndtype = 0xFF & b.getOctet(0);
        if (ndtype == 1) {
            return new SourceLLA(b);
        }
        if (ndtype == 2) {
            return new TargetLLA(b);
        }
        if (ndtype == 3) {
            return new PrefixInfo(b);
        }
        if (ndtype == 4) {
            return new RedirectedHeader(b);
        }
        if (ndtype == 5) {
            return new MTU(b);
        }
        return null;
    }

    @Override
    public int getHeaderLen() {
        return this.rawheader.getOctet(8) * 64;
    }

    @Override
    public Header getNextHeader() {
        if (this.rawpayload.getBitSize() == 0) {
            return null;
        }
        return NDOption.createNDOption(this.rawpayload);
    }

    public String getNDType() {
        return this.ndtype.toString();
    }

    public String getLength() {
        return this.length.toString();
    }
}

