/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.http.impl;

import com.clickhouse.client.internal.org.apache.hc.core5.annotation.Contract;
import com.clickhouse.client.internal.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.clickhouse.client.internal.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.clickhouse.client.internal.org.apache.hc.core5.http.Header;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpRequest;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpResponse;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpVersion;
import com.clickhouse.client.internal.org.apache.hc.core5.http.ProtocolVersion;
import com.clickhouse.client.internal.org.apache.hc.core5.http.message.BasicTokenIterator;
import com.clickhouse.client.internal.org.apache.hc.core5.http.message.MessageSupport;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.HttpContext;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Args;
import java.util.Iterator;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpRequest request, HttpResponse response, HttpContext context) {
        Iterator<Header> headerIterator;
        ProtocolVersion ver;
        Header teh;
        Args.notNull(response, "HTTP response");
        if (request != null) {
            if (request.containsHeader("Content-Length") && request.containsHeader("Transfer-Encoding")) {
                return false;
            }
            Iterator<String> it = MessageSupport.iterateTokens(request, "Connection");
            while (it.hasNext()) {
                String token = it.next();
                if (!"close".equalsIgnoreCase(token)) continue;
                return false;
            }
        }
        if ((teh = response.getFirstHeader("Transfer-Encoding")) == null && MessageSupport.canResponseHaveBody(request != null ? request.getMethod() : null, response) && response.countHeaders("Content-Length") != 1) {
            return false;
        }
        ProtocolVersion protocolVersion = ver = response.getVersion() != null ? response.getVersion() : context.getProtocolVersion();
        if (ver.lessEquals(HttpVersion.HTTP_1_0) && teh != null) {
            return false;
        }
        if (response.getCode() == 204) {
            Header clh = response.getFirstHeader("Content-Length");
            if (clh != null) {
                try {
                    long contentLen = Long.parseLong(clh.getValue());
                    if (contentLen > 0L) {
                        return false;
                    }
                }
                catch (NumberFormatException contentLen) {
                    // empty catch block
                }
            }
            if (response.containsHeader("Transfer-Encoding")) {
                return false;
            }
        }
        if (!(headerIterator = response.headerIterator("Connection")).hasNext()) {
            headerIterator = response.headerIterator("Proxy-Connection");
        }
        if (headerIterator.hasNext()) {
            if (ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                BasicTokenIterator it = new BasicTokenIterator(headerIterator);
                while (it.hasNext()) {
                    String token = (String)it.next();
                    if (!"close".equalsIgnoreCase(token)) continue;
                    return false;
                }
                return true;
            }
            BasicTokenIterator it = new BasicTokenIterator(headerIterator);
            while (it.hasNext()) {
                String token = (String)it.next();
                if (!"keep-alive".equalsIgnoreCase(token)) continue;
                return true;
            }
            return false;
        }
        return ver.greaterEquals(HttpVersion.HTTP_1_1);
    }
}

