/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.EitherSerializer;
import org.apache.flink.api.java.typeutils.runtime.EitherSerializerSnapshot;
import org.apache.flink.types.Either;

public class JavaEitherSerializerSnapshot<L, R>
extends CompositeTypeSerializerSnapshot<Either<L, R>, EitherSerializer<L, R>> {
    private static final int CURRENT_VERSION = 1;

    public JavaEitherSerializerSnapshot() {
    }

    public JavaEitherSerializerSnapshot(EitherSerializer<L, R> eitherSerializer) {
        super(eitherSerializer);
    }

    @Override
    protected int getCurrentOuterSnapshotVersion() {
        return 1;
    }

    @Override
    public TypeSerializerSchemaCompatibility<Either<L, R>> resolveSchemaCompatibility(TypeSerializerSnapshot<Either<L, R>> oldSerializerSnapshot) {
        if (oldSerializerSnapshot instanceof EitherSerializerSnapshot) {
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(oldSerializerSnapshot, this, Objects.requireNonNull(((EitherSerializerSnapshot)oldSerializerSnapshot).getNestedSerializerSnapshots()));
        }
        return super.resolveSchemaCompatibility(oldSerializerSnapshot);
    }

    @Override
    protected EitherSerializer<L, R> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
        TypeSerializer<?> leftSerializer = nestedSerializers[0];
        TypeSerializer<?> rightSerializer = nestedSerializers[1];
        return new EitherSerializer(leftSerializer, rightSerializer);
    }

    @Override
    protected TypeSerializer<?>[] getNestedSerializers(EitherSerializer<L, R> outerSerializer) {
        return new TypeSerializer[]{outerSerializer.getLeftSerializer(), outerSerializer.getRightSerializer()};
    }
}

