/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class EnumSerializer<T extends Enum<T>>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> enumClass;
    private Map<T, Integer> valueToOrdinal;
    private T[] values;

    public EnumSerializer(Class<T> enumClass) {
        this(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    private EnumSerializer(Class<T> enumClass, T[] enumValues) {
        this.enumClass = Preconditions.checkNotNull(enumClass);
        this.values = (Enum[])Preconditions.checkNotNull(enumValues);
        Preconditions.checkArgument(Enum.class.isAssignableFrom(enumClass), "not an enum");
        Preconditions.checkArgument(this.values.length > 0, "cannot use an empty enum");
        this.valueToOrdinal = new EnumMap<T, Integer>(this.enumClass);
        int i = 0;
        for (T value : this.values) {
            this.valueToOrdinal.put(value, i++);
        }
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public EnumSerializer<T> duplicate() {
        return this;
    }

    @Override
    public T createInstance() {
        Preconditions.checkState(this.values != null);
        return this.values[0];
    }

    @Override
    public T copy(T from) {
        return from;
    }

    @Override
    public T copy(T from, T reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        target.writeInt(this.valueToOrdinal.get(record));
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 4);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EnumSerializer) {
            EnumSerializer other = (EnumSerializer)obj;
            return other.enumClass == this.enumClass && Arrays.equals(this.values, other.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.enumClass.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.values == null) {
            this.values = (Enum[])this.enumClass.getEnumConstants();
            this.valueToOrdinal = new EnumMap<T, Integer>(this.enumClass);
            int i = 0;
            for (T value : this.values) {
                this.valueToOrdinal.put(value, i++);
            }
        }
    }

    @Override
    public EnumSerializerSnapshot<T> snapshotConfiguration() {
        return new EnumSerializerSnapshot(this.enumClass, this.values);
    }

    @VisibleForTesting
    T[] getValues() {
        return this.values;
    }

    @VisibleForTesting
    Map<T, Integer> getValueToOrdinal() {
        return this.valueToOrdinal;
    }

    public String toString() {
        return "EnumSerializer{enumClass=" + this.enumClass + ", values=" + Arrays.toString(this.values) + '}';
    }

    public static final class EnumSerializerSnapshot<T extends Enum<T>>
    implements TypeSerializerSnapshot<T> {
        private static final int CURRENT_VERSION = 3;
        private T[] enums;
        private Class<T> enumClass;

        public EnumSerializerSnapshot() {
        }

        EnumSerializerSnapshot(Class<T> enumClass, T[] enums) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
            this.enums = (Enum[])Preconditions.checkNotNull(enums);
        }

        @Override
        public int getCurrentVersion() {
            return 3;
        }

        @Override
        public void writeSnapshot(DataOutputView out) throws IOException {
            Preconditions.checkState(this.enumClass != null, "Enum class can not be null.");
            out.writeUTF(this.enumClass.getName());
            out.writeInt(this.enums.length);
            for (T enumConstant : this.enums) {
                out.writeUTF(((Enum)enumConstant).name());
            }
        }

        @Override
        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.enumClass = InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
            int numEnumConstants = in.readInt();
            Enum[] previousEnums = (Enum[])Array.newInstance(this.enumClass, numEnumConstants);
            for (int i = 0; i < numEnumConstants; ++i) {
                String enumName = in.readUTF();
                try {
                    previousEnums[i] = Enum.valueOf(this.enumClass, enumName);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Could not create a restore serializer for enum " + this.enumClass + ". Probably because an enum value was removed.");
                }
            }
            this.enums = previousEnums;
        }

        @Override
        public TypeSerializer<T> restoreSerializer() {
            Preconditions.checkState(this.enumClass != null, "Enum class can not be null.");
            return new EnumSerializer(this.enumClass, (Enum[])this.enums);
        }

        @Override
        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializerSnapshot<T> oldSerializerSnapshot) {
            if (!(oldSerializerSnapshot instanceof EnumSerializerSnapshot)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            EnumSerializerSnapshot oldEnumSerializerSnapshot = (EnumSerializerSnapshot)oldSerializerSnapshot;
            if (!this.enumClass.equals(oldEnumSerializerSnapshot.enumClass)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            Object[] currentEnums = (Enum[])this.enumClass.getEnumConstants();
            if (Arrays.equals(oldEnumSerializerSnapshot.enums, currentEnums)) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
            LinkedHashSet<Enum> reconfiguredEnumSet = new LinkedHashSet<Enum>(Arrays.asList(oldEnumSerializerSnapshot.enums));
            reconfiguredEnumSet.addAll(Arrays.asList(currentEnums));
            Enum[] reconfiguredEnums = reconfiguredEnumSet.toArray((Enum[])Array.newInstance(this.enumClass, reconfiguredEnumSet.size()));
            EnumSerializer reconfiguredSerializer = new EnumSerializer(this.enumClass, reconfiguredEnums);
            return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer(reconfiguredSerializer);
        }
    }
}

