/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.blobstore;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.SharedAccessAccountPolicy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemUtils;
import org.apache.beam.sdk.io.azure.blobstore.AzfsResourceId;
import org.apache.beam.sdk.io.azure.blobstore.AzureReadableSeekableByteChannel;
import org.apache.beam.sdk.io.azure.options.BlobstoreClientBuilderFactory;
import org.apache.beam.sdk.io.azure.options.BlobstoreOptions;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureBlobStoreFileSystem
extends FileSystem<AzfsResourceId> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(AzureBlobStoreFileSystem.class);
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> NON_READ_SEEK_EFFICIENT_ENCODINGS = ImmutableSet.of((Object)"gzip");
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_EXPIRY_TIME = 86400000;
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_PERMISSIONS = "racwdlup";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_RESOURCE_TYPES = "co";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_SERVICES = "b";
    private @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized BlobServiceClient> client;
    private final @UnknownKeyFor @NonNull @Initialized BlobstoreOptions options;

    AzureBlobStoreFileSystem(@UnknownKeyFor @NonNull @Initialized BlobstoreOptions options) {
        this.options = (BlobstoreOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
        BlobServiceClientBuilder builder = ((BlobstoreClientBuilderFactory)InstanceBuilder.ofType(BlobstoreClientBuilderFactory.class).fromClass(options.getBlobstoreClientFactoryClass()).build()).createBuilder(options);
        this.client = Suppliers.memoize(() -> ((BlobServiceClientBuilder)builder).buildClient());
    }

    @VisibleForTesting
    void setClient(@UnknownKeyFor @NonNull @Initialized BlobServiceClient client) {
        this.client = Suppliers.ofInstance((Object)client);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized BlobServiceClient getClient() {
        return (BlobServiceClient)this.client.get();
    }

    protected @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return "azfs";
    }

    protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> match(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs) {
        List paths = specs.stream().map(AzfsResourceId::fromUri).collect(Collectors.toList());
        ArrayList<AzfsResourceId> globs = new ArrayList<AzfsResourceId>();
        ArrayList<AzfsResourceId> nonGlobs = new ArrayList<AzfsResourceId>();
        ArrayList<Boolean> isGlobBooleans = new ArrayList<Boolean>();
        for (AzfsResourceId path : paths) {
            if (path.isWildcard()) {
                globs.add(path);
                isGlobBooleans.add(true);
                continue;
            }
            nonGlobs.add(path);
            isGlobBooleans.add(false);
        }
        Iterator<MatchResult> globMatches = this.matchGlobPaths(globs).iterator();
        Iterator<MatchResult> nonGlobMatches = this.matchNonGlobPaths(nonGlobs).iterator();
        ImmutableList.Builder matchResults = ImmutableList.builder();
        for (Boolean isGlob : isGlobBooleans) {
            if (isGlob.booleanValue()) {
                Preconditions.checkState((boolean)globMatches.hasNext(), (Object)"Internal error encountered in AzureBlobStoreFileSystem: expected more elements in globMatches.");
                matchResults.add((Object)globMatches.next());
                continue;
            }
            Preconditions.checkState((boolean)nonGlobMatches.hasNext(), (Object)"Internal error encountered in AzureBlobStoreFileSystem: expected more elements in nonGlobMatches.");
            matchResults.add((Object)nonGlobMatches.next());
        }
        Preconditions.checkState((!globMatches.hasNext() ? 1 : 0) != 0, (Object)"Internal error encountered in AzureBlobStoreFileSystem: expected no more elements in globMatches.");
        Preconditions.checkState((!nonGlobMatches.hasNext() ? 1 : 0) != 0, (Object)"Internal error encountered in AzureBlobStoreFileSystem: expected no more elements in nonGlobMatches.");
        return matchResults.build();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> matchGlobPaths(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AzfsResourceId> globs) {
        return FluentIterable.from(globs).transform(this::expand).toList();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized MatchResult expand(@UnknownKeyFor @NonNull @Initialized AzfsResourceId azfsPattern) {
        Preconditions.checkArgument((boolean)azfsPattern.isWildcard(), (Object)"The resource id should be a wildcard.");
        String blobPrefix = azfsPattern.getBlobNonWildcardPrefix();
        Pattern wildcardAsRegexp = Pattern.compile(FileSystemUtils.wildcardToRegexp((String)azfsPattern.getBlob()));
        LOG.debug("matching files in container {}, prefix {} against pattern {}", new Object[]{azfsPattern.getContainer(), blobPrefix, wildcardAsRegexp.toString()});
        ListBlobsOptions listOptions = new ListBlobsOptions().setPrefix(blobPrefix);
        Duration timeout = Duration.ofMinutes(1L);
        String account = azfsPattern.getAccount();
        String container = azfsPattern.getContainer();
        BlobContainerClient blobContainerClient = ((BlobServiceClient)this.client.get()).getBlobContainerClient(container);
        PagedIterable blobs = blobContainerClient.listBlobs(listOptions, timeout);
        ArrayList results = new ArrayList();
        blobs.forEach(blob -> {
            String name = blob.getName();
            if (wildcardAsRegexp.matcher(name).matches() && !name.endsWith("/")) {
                LOG.debug("Matched object: azfs://{}/{}/{}", new Object[]{account, container, name});
                BlobProperties properties = blobContainerClient.getBlobClient(name).getProperties();
                AzfsResourceId rid = AzfsResourceId.fromComponents(account, container, name).withSize(properties.getBlobSize()).withLastModified(Date.from(properties.getLastModified().toInstant()));
                results.add(this.toMetadata(rid, properties.getContentEncoding(), properties.getETag()));
            }
        });
        return MatchResult.create((MatchResult.Status)MatchResult.Status.OK, results);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata toMetadata(@UnknownKeyFor @NonNull @Initialized AzfsResourceId path, @UnknownKeyFor @NonNull @Initialized String contentEncoding, @UnknownKeyFor @NonNull @Initialized String eTag) {
        Preconditions.checkArgument((path.getSize() != null ? 1 : 0) != 0, (Object)"The resource id should have a size.");
        boolean isReadSeekEfficient = !NON_READ_SEEK_EFFICIENT_ENCODINGS.contains((Object)contentEncoding);
        MatchResult.Metadata.Builder ret = MatchResult.Metadata.builder().setIsReadSeekEfficient(isReadSeekEfficient).setResourceId((ResourceId)path).setSizeBytes(path.getSize().longValue()).setLastModifiedMillis(((Long)path.getLastModified().transform(Date::getTime).or((Object)0L)).longValue());
        if (eTag != null) {
            ret.setChecksum(eTag);
        }
        return ret.build();
    }

    @VisibleForTesting
    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MatchResult> matchNonGlobPaths(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AzfsResourceId> paths) {
        ImmutableList.Builder toReturn = ImmutableList.builder();
        for (AzfsResourceId path : paths) {
            toReturn.add((Object)this.toMatchResult(path));
        }
        return toReturn.build();
    }

    private @UnknownKeyFor @NonNull @Initialized MatchResult toMatchResult(@UnknownKeyFor @NonNull @Initialized AzfsResourceId path) {
        BlobProperties blobProperties;
        BlobClient blobClient = ((BlobServiceClient)this.client.get()).getBlobContainerClient(path.getContainer()).getBlobClient(path.getBlob());
        try {
            blobProperties = blobClient.getProperties();
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 404) {
                return MatchResult.create((MatchResult.Status)MatchResult.Status.NOT_FOUND, (IOException)new FileNotFoundException());
            }
            return MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)new IOException(e));
        }
        return MatchResult.create((MatchResult.Status)MatchResult.Status.OK, (List)ImmutableList.of((Object)this.toMetadata(path.withSize(blobProperties.getBlobSize()).withLastModified(Date.from(blobProperties.getLastModified().toInstant())), blobProperties.getContentEncoding(), blobProperties.getETag())));
    }

    protected @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized AzfsResourceId resourceId, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BlobOutputStream outputStream;
        BlobContainerClient blobContainerClient = ((BlobServiceClient)this.client.get()).getBlobContainerClient(resourceId.getContainer());
        if (!blobContainerClient.exists()) {
            throw new FileNotFoundException("This container does not exist. Creating containers is not supported.");
        }
        BlobClient blobClient = blobContainerClient.getBlobClient(resourceId.getBlob());
        if (blobClient.exists().booleanValue()) {
            throw new IOException("This filename is already in use.");
        }
        try {
            outputStream = blobClient.getBlockBlobClient().getBlobOutputStream();
        }
        catch (BlobStorageException e) {
            throw (IOException)e.getCause();
        }
        return Channels.newChannel((OutputStream)outputStream);
    }

    protected @UnknownKeyFor @NonNull @Initialized ReadableByteChannel open(@UnknownKeyFor @NonNull @Initialized AzfsResourceId resourceId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BlobContainerClient containerClient = ((BlobServiceClient)this.client.get()).getBlobContainerClient(resourceId.getContainer());
        if (!containerClient.exists()) {
            throw new FileNotFoundException("The requested file doesn't exist.");
        }
        BlobClient blobClient = containerClient.getBlobClient(resourceId.getBlob());
        if (!blobClient.exists().booleanValue()) {
            throw new FileNotFoundException("The requested file doesn't exist.");
        }
        LOG.info("Creating a ReadableByteChannel for {}", (Object)resourceId);
        return new AzureReadableSeekableByteChannel(blobClient);
    }

    protected void copy(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AzfsResourceId> srcPaths, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AzfsResourceId> destPaths) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument((srcPaths.size() == destPaths.size() ? 1 : 0) != 0, (Object)"sizes of source paths and destination paths do not match");
        Iterator<AzfsResourceId> sourcePathsIterator = srcPaths.iterator();
        Iterator<AzfsResourceId> destinationPathsIterator = destPaths.iterator();
        while (sourcePathsIterator.hasNext()) {
            AzfsResourceId sourcePath = sourcePathsIterator.next();
            AzfsResourceId destinationPath = destinationPathsIterator.next();
            this.copy(sourcePath, destinationPath);
        }
    }

    @VisibleForTesting
    void copy(@UnknownKeyFor @NonNull @Initialized AzfsResourceId sourcePath, @UnknownKeyFor @NonNull @Initialized AzfsResourceId destinationPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument((sourcePath.getBlob() != null && destinationPath.getBlob() != null ? 1 : 0) != 0, (Object)"This method is intended to copy file-like resources, not directories.");
        BlobClient srcBlobClient = ((BlobServiceClient)this.client.get()).getBlobContainerClient(sourcePath.getContainer()).getBlobClient(sourcePath.getBlob());
        if (!srcBlobClient.exists().booleanValue()) {
            throw new FileNotFoundException("The copy source does not exist.");
        }
        BlobContainerClient destBlobContainerClient = ((BlobServiceClient)this.client.get()).getBlobContainerClient(destinationPath.getContainer());
        if (!destBlobContainerClient.exists()) {
            ((BlobServiceClient)this.client.get()).createBlobContainer(destinationPath.getContainer());
            LOG.info("Created a container called {}", (Object)destinationPath.getContainer());
        }
        BlobClient destBlobClient = destBlobContainerClient.getBlobClient(destinationPath.getBlob());
        destBlobClient.copyFromUrl(srcBlobClient.getBlobUrl() + this.generateSasToken());
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized String generateSasToken() throws @UnknownKeyFor @NonNull @Initialized IOException {
        String storageConnectionString;
        if (!Strings.isNullOrEmpty((String)this.options.getSasToken())) {
            return this.options.getSasToken();
        }
        SharedAccessAccountPolicy sharedAccessAccountPolicy = new SharedAccessAccountPolicy();
        long date = new Date().getTime();
        long expiryDate = new Date(date + 86400000L).getTime();
        sharedAccessAccountPolicy.setPermissionsFromString(DEFAULT_PERMISSIONS);
        sharedAccessAccountPolicy.setSharedAccessStartTime(new Date(date));
        sharedAccessAccountPolicy.setSharedAccessExpiryTime(new Date(expiryDate));
        sharedAccessAccountPolicy.setResourceTypeFromString(DEFAULT_RESOURCE_TYPES);
        sharedAccessAccountPolicy.setServiceFromString(DEFAULT_SERVICES);
        if (!Strings.isNullOrEmpty((String)this.options.getAzureConnectionString())) {
            storageConnectionString = this.options.getAzureConnectionString();
        } else if (!Strings.isNullOrEmpty((String)this.options.getAccessKey())) {
            storageConnectionString = "DefaultEndpointsProtocol=https;AccountName=" + ((BlobServiceClient)this.client.get()).getAccountName() + ";AccountKey=" + this.options.getAccessKey() + ";EndpointSuffix=core.windows.net";
        } else {
            throw new IOException("Copying blobs requires that a SAS token, connection string, or account key be provided.");
        }
        try {
            CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)storageConnectionString);
            return "?" + storageAccount.generateSharedAccessSignature(sharedAccessAccountPolicy);
        }
        catch (Exception e) {
            throw (IOException)e.getCause();
        }
    }

    protected void rename(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AzfsResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AzfsResourceId> destResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (moveOptions.length > 0) {
            throw new UnsupportedOperationException("Support for move options is not yet implemented.");
        }
        this.copy(srcResourceIds, destResourceIds);
        this.delete(srcResourceIds);
    }

    protected void delete(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized AzfsResourceId> resourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (AzfsResourceId resourceId : resourceIds) {
            if (resourceId.getBlob() == null) {
                throw new IOException("delete does not delete containers.");
            }
            BlobContainerClient container = ((BlobServiceClient)this.client.get()).getBlobContainerClient(resourceId.getContainer());
            if (!resourceId.isDirectory()) {
                BlobClient blob2 = container.getBlobClient(resourceId.getBlob());
                if (!blob2.exists().booleanValue()) {
                    throw new FileNotFoundException("The resource to delete does not exist.");
                }
                blob2.delete();
                continue;
            }
            PagedIterable blobsInDirectory = container.listBlobsByHierarchy(resourceId.getBlob());
            blobsInDirectory.forEach(blob -> {
                String blobName = blob.getName();
                container.getBlobClient(blobName).delete();
            });
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized AzfsResourceId matchNewResource(@UnknownKeyFor @NonNull @Initialized String singleResourceSpec, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        if (isDirectory) {
            if (!singleResourceSpec.endsWith("/")) {
                singleResourceSpec = singleResourceSpec + "/";
            }
        } else {
            Preconditions.checkArgument((!singleResourceSpec.endsWith("/") ? 1 : 0) != 0, (String)"Expected a file path, but [%s] ends with '/'. This is unsupported in AzfsFileSystem.", (Object)singleResourceSpec);
        }
        return AzfsResourceId.fromUri(singleResourceSpec);
    }

    protected void reportLineage(@UnknownKeyFor @NonNull @Initialized AzfsResourceId resourceId, @UnknownKeyFor @NonNull @Initialized Lineage lineage) {
        this.reportLineage(resourceId, lineage, FileSystem.LineageLevel.FILE);
    }

    protected void reportLineage(@UnknownKeyFor @NonNull @Initialized AzfsResourceId resourceId, @UnknownKeyFor @NonNull @Initialized Lineage lineage, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized FileSystem.LineageLevel level) {
        if (level != FileSystem.LineageLevel.TOP_LEVEL && !Strings.isNullOrEmpty((String)resourceId.getBlob())) {
            lineage.add("abs", (Iterable)ImmutableList.of((Object)resourceId.getAccount(), (Object)resourceId.getContainer(), (Object)resourceId.getBlob()));
        } else {
            lineage.add("abs", (Iterable)ImmutableList.of((Object)resourceId.getAccount(), (Object)resourceId.getContainer()));
        }
    }
}

