/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.util.Preconditions;

public interface ResultSubpartitionView {
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() throws IOException;

    public void notifyDataAvailable();

    default public void notifyPriorityEvent(int priorityBufferNumber) {
    }

    public void releaseAllResources() throws IOException;

    public boolean isReleased();

    public void resumeConsumption();

    public void acknowledgeAllDataProcessed();

    public Throwable getFailureCause();

    public AvailabilityWithBacklog getAvailabilityAndBacklog(boolean var1);

    public int unsynchronizedGetNumberOfQueuedBuffers();

    public int getNumberOfQueuedBuffers();

    public void notifyNewBufferSize(int var1);

    default public void notifyRequiredSegmentId(int subpartitionId, int segmentId) {
    }

    public int peekNextBufferSubpartitionId() throws IOException;

    public static class AvailabilityWithBacklog {
        private final boolean isAvailable;
        private final int backlog;

        public AvailabilityWithBacklog(boolean isAvailable, int backlog) {
            Preconditions.checkArgument((backlog >= 0 ? 1 : 0) != 0, (Object)"Backlog must be non-negative.");
            this.isAvailable = isAvailable;
            this.backlog = backlog;
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }

        public int getBacklog() {
            return this.backlog;
        }
    }
}

