/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaderDecider;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.HashKeyRangeForLease;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.UpdateField;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.util.CollectionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PeriodicShardSyncManager {
    private static final Log LOG = LogFactory.getLog(PeriodicShardSyncManager.class);
    private static final long INITIAL_DELAY = 0L;
    private static final long DEFAULT_PERIODIC_SHARD_SYNC_INTERVAL_MILLIS = 1000L;
    @VisibleForTesting
    static final BigInteger MIN_HASH_KEY = BigInteger.ZERO;
    @VisibleForTesting
    static final BigInteger MAX_HASH_KEY = new BigInteger("2").pow(128).subtract(BigInteger.ONE);
    static final String PERIODIC_SHARD_SYNC_MANAGER = "PeriodicShardSyncManager";
    private final HashRangeHoleTracker hashRangeHoleTracker = new HashRangeHoleTracker();
    private final String workerId;
    private final LeaderDecider leaderDecider;
    private final ITask metricsEmittingShardSyncTask;
    private final ScheduledExecutorService shardSyncThreadPool;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final IKinesisProxy kinesisProxy;
    private final boolean isAuditorMode;
    private final long periodicShardSyncIntervalMillis;
    private boolean isRunning;
    private final IMetricsFactory metricsFactory;
    private final int leasesRecoveryAuditorInconsistencyConfidenceThreshold;

    PeriodicShardSyncManager(String workerId, LeaderDecider leaderDecider, ShardSyncTask shardSyncTask, IMetricsFactory metricsFactory, ILeaseManager<KinesisClientLease> leaseManager, IKinesisProxy kinesisProxy, boolean isAuditorMode, long leasesRecoveryAuditorExecutionFrequencyMillis, int leasesRecoveryAuditorInconsistencyConfidenceThreshold) {
        this(workerId, leaderDecider, shardSyncTask, Executors.newSingleThreadScheduledExecutor(), metricsFactory, leaseManager, kinesisProxy, isAuditorMode, leasesRecoveryAuditorExecutionFrequencyMillis, leasesRecoveryAuditorInconsistencyConfidenceThreshold);
    }

    PeriodicShardSyncManager(String workerId, LeaderDecider leaderDecider, ShardSyncTask shardSyncTask, ScheduledExecutorService shardSyncThreadPool, IMetricsFactory metricsFactory, ILeaseManager<KinesisClientLease> leaseManager, IKinesisProxy kinesisProxy, boolean isAuditorMode, long leasesRecoveryAuditorExecutionFrequencyMillis, int leasesRecoveryAuditorInconsistencyConfidenceThreshold) {
        Validate.notBlank((CharSequence)workerId, (String)"WorkerID is required to initialize PeriodicShardSyncManager.", (Object[])new Object[0]);
        Validate.notNull((Object)leaderDecider, (String)"LeaderDecider is required to initialize PeriodicShardSyncManager.", (Object[])new Object[0]);
        Validate.notNull((Object)shardSyncTask, (String)"ShardSyncTask is required to initialize PeriodicShardSyncManager.", (Object[])new Object[0]);
        this.workerId = workerId;
        this.leaderDecider = leaderDecider;
        this.metricsEmittingShardSyncTask = new MetricsCollectingTaskDecorator(shardSyncTask, metricsFactory);
        this.shardSyncThreadPool = shardSyncThreadPool;
        this.leaseManager = leaseManager;
        this.kinesisProxy = kinesisProxy;
        this.metricsFactory = metricsFactory;
        this.isAuditorMode = isAuditorMode;
        this.leasesRecoveryAuditorInconsistencyConfidenceThreshold = leasesRecoveryAuditorInconsistencyConfidenceThreshold;
        if (isAuditorMode) {
            Validate.notNull(this.leaseManager, (String)"LeaseManager is required for non-PERIODIC shard sync strategies.", (Object[])new Object[0]);
            Validate.notNull((Object)this.kinesisProxy, (String)"KinesisProxy is required for non-PERIODIC shard sync strategies.", (Object[])new Object[0]);
            this.periodicShardSyncIntervalMillis = leasesRecoveryAuditorExecutionFrequencyMillis;
        } else {
            this.periodicShardSyncIntervalMillis = 1000L;
        }
    }

    public synchronized TaskResult start() {
        if (!this.isRunning) {
            Runnable periodicShardSyncer = () -> {
                try {
                    this.runShardSync();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error running shard sync.", t);
                }
            };
            this.shardSyncThreadPool.scheduleWithFixedDelay(periodicShardSyncer, 0L, this.periodicShardSyncIntervalMillis, TimeUnit.MILLISECONDS);
            this.isRunning = true;
        }
        return new TaskResult(null);
    }

    public synchronized TaskResult syncShardsOnce() {
        LOG.info((Object)("Syncing shards once from worker " + this.workerId));
        return this.metricsEmittingShardSyncTask.call();
    }

    public void stop() {
        if (this.isRunning) {
            LOG.info((Object)String.format("Shutting down leader decider on worker %s", this.workerId));
            this.leaderDecider.shutdown();
            LOG.info((Object)String.format("Shutting down periodic shard sync task scheduler on worker %s", this.workerId));
            this.shardSyncThreadPool.shutdown();
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runShardSync() {
        if (this.leaderDecider.isLeader(this.workerId).booleanValue()) {
            LOG.debug((Object)("WorkerId " + this.workerId + " is a leader, running the shard sync task"));
            MetricsHelper.startScope(this.metricsFactory, PERIODIC_SHARD_SYNC_MANAGER);
            boolean isRunSuccess = false;
            long runStartMillis = System.currentTimeMillis();
            try {
                ShardSyncResponse shardSyncResponse = this.checkForShardSync();
                MetricsHelper.getMetricsScope().addData("NumStreamsToSync", shardSyncResponse.shouldDoShardSync() ? 1.0 : 0.0, StandardUnit.Count, MetricsLevel.SUMMARY);
                MetricsHelper.getMetricsScope().addData("NumStreamsWithPartialLeases", shardSyncResponse.isHoleDetected() ? 1.0 : 0.0, StandardUnit.Count, MetricsLevel.SUMMARY);
                if (shardSyncResponse.shouldDoShardSync()) {
                    LOG.info((Object)("Periodic shard syncer initiating shard sync due to the reason - " + shardSyncResponse.reasonForDecision()));
                    this.metricsEmittingShardSyncTask.call();
                } else {
                    LOG.info((Object)("Skipping shard sync due to the reason - " + shardSyncResponse.reasonForDecision()));
                }
                isRunSuccess = true;
            }
            catch (Exception e) {
                LOG.error((Object)"Caught exception while running periodic shard syncer.", (Throwable)e);
            }
            finally {
                MetricsHelper.addSuccessAndLatency(runStartMillis, isRunSuccess, MetricsLevel.SUMMARY);
                MetricsHelper.endScope();
            }
        } else {
            LOG.debug((Object)("WorkerId " + this.workerId + " is not a leader, not running the shard sync task"));
        }
    }

    @VisibleForTesting
    ShardSyncResponse checkForShardSync() throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        if (!this.isAuditorMode) {
            return new ShardSyncResponse(true, false, "Syncing every time with PERIODIC shard sync strategy.");
        }
        List<KinesisClientLease> currentLeases = this.leaseManager.listLeases();
        if (CollectionUtils.isNullOrEmpty(currentLeases)) {
            LOG.info((Object)"No leases found. Will trigger a shard sync.");
            return new ShardSyncResponse(true, false, "No leases found.");
        }
        Optional<HashRangeHole> hashRangeHoleOpt = this.hasHoleInLeases(currentLeases);
        if (hashRangeHoleOpt.isPresent()) {
            boolean hasHoleWithHighConfidence = this.hashRangeHoleTracker.hashHighConfidenceOfHoleWith(hashRangeHoleOpt.get());
            return new ShardSyncResponse(hasHoleWithHighConfidence, true, "Detected the same hole for " + this.hashRangeHoleTracker.getNumConsecutiveHoles() + " times. Will initiate shard sync after reaching threshold: " + this.leasesRecoveryAuditorInconsistencyConfidenceThreshold);
        }
        this.hashRangeHoleTracker.reset();
        return new ShardSyncResponse(false, false, "Hash range is complete.");
    }

    @VisibleForTesting
    Optional<HashRangeHole> hasHoleInLeases(List<KinesisClientLease> leases) {
        List<KinesisClientLease> activeLeases = leases.stream().filter(lease -> lease.getCheckpoint() != null && !lease.getCheckpoint().isShardEnd()).collect(Collectors.toList());
        List<KinesisClientLease> activeLeasesWithHashRanges = this.fillWithHashRangesIfRequired(activeLeases);
        return PeriodicShardSyncManager.checkForHoleInHashKeyRanges(activeLeasesWithHashRanges);
    }

    private List<KinesisClientLease> fillWithHashRangesIfRequired(List<KinesisClientLease> activeLeases) {
        List activeLeasesWithNoHashRanges = activeLeases.stream().filter(lease -> lease.getHashKeyRange() == null).collect(Collectors.toList());
        if (activeLeasesWithNoHashRanges.isEmpty()) {
            return activeLeases;
        }
        Map<String, Shard> kinesisShards = this.kinesisProxy.getShardList().stream().collect(Collectors.toMap(Shard::getShardId, shard -> shard));
        return activeLeases.stream().map(lease -> {
            if (lease.getHashKeyRange() == null) {
                String shardId = lease.getLeaseKey();
                Shard shard = (Shard)kinesisShards.get(shardId);
                if (shard == null) {
                    return lease;
                }
                lease.setHashKeyRange(HashKeyRangeForLease.fromHashKeyRange(shard.getHashKeyRange()));
                try {
                    this.leaseManager.updateLeaseWithMetaInfo((KinesisClientLease)lease, UpdateField.HASH_KEY_RANGE);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Unable to update hash range information for lease " + lease.getLeaseKey() + ". This may result in explicit lease sync."));
                }
            }
            return lease;
        }).filter(lease -> lease.getHashKeyRange() != null).collect(Collectors.toList());
    }

    @VisibleForTesting
    static Optional<HashRangeHole> checkForHoleInHashKeyRanges(List<KinesisClientLease> leasesWithHashKeyRanges) {
        List<KinesisClientLease> sortedLeasesWithHashKeyRanges = PeriodicShardSyncManager.sortLeasesByHashRange(leasesWithHashKeyRanges);
        if (sortedLeasesWithHashKeyRanges.isEmpty()) {
            LOG.error((Object)"No leases with valid hash ranges found.");
            return Optional.of(new HashRangeHole());
        }
        KinesisClientLease minHashKeyLease = sortedLeasesWithHashKeyRanges.get(0);
        KinesisClientLease maxHashKeyLease = sortedLeasesWithHashKeyRanges.get(sortedLeasesWithHashKeyRanges.size() - 1);
        if (!minHashKeyLease.getHashKeyRange().startingHashKey().equals(MIN_HASH_KEY) || !maxHashKeyLease.getHashKeyRange().endingHashKey().equals(MAX_HASH_KEY)) {
            LOG.error((Object)("Incomplete hash range found between " + minHashKeyLease + " and " + maxHashKeyLease));
            return Optional.of(new HashRangeHole(minHashKeyLease.getHashKeyRange(), maxHashKeyLease.getHashKeyRange()));
        }
        if (sortedLeasesWithHashKeyRanges.size() > 1) {
            KinesisClientLease leftmostLeaseToReportInCaseOfHole = minHashKeyLease;
            HashKeyRangeForLease leftLeaseHashRange = leftmostLeaseToReportInCaseOfHole.getHashKeyRange();
            for (int i = 1; i < sortedLeasesWithHashKeyRanges.size(); ++i) {
                KinesisClientLease rightLease = sortedLeasesWithHashKeyRanges.get(i);
                HashKeyRangeForLease rightLeaseHashRange = rightLease.getHashKeyRange();
                BigInteger rangeDiff = rightLeaseHashRange.startingHashKey().subtract(leftLeaseHashRange.endingHashKey());
                if (rangeDiff.signum() <= 0) {
                    leftLeaseHashRange = new HashKeyRangeForLease(leftLeaseHashRange.startingHashKey(), leftLeaseHashRange.endingHashKey().max(rightLeaseHashRange.endingHashKey()));
                    continue;
                }
                if (!rangeDiff.equals(BigInteger.ONE)) {
                    LOG.error((Object)("Incomplete hash range found between " + leftmostLeaseToReportInCaseOfHole + " and " + rightLease));
                    return Optional.of(new HashRangeHole(leftmostLeaseToReportInCaseOfHole.getHashKeyRange(), rightLease.getHashKeyRange()));
                }
                leftmostLeaseToReportInCaseOfHole = rightLease;
                leftLeaseHashRange = rightLeaseHashRange;
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static List<KinesisClientLease> sortLeasesByHashRange(List<KinesisClientLease> leasesWithHashKeyRanges) {
        if (leasesWithHashKeyRanges.size() == 0 || leasesWithHashKeyRanges.size() == 1) {
            return leasesWithHashKeyRanges;
        }
        Collections.sort(leasesWithHashKeyRanges, new HashKeyRangeComparator());
        return leasesWithHashKeyRanges;
    }

    public HashRangeHoleTracker getHashRangeHoleTracker() {
        return this.hashRangeHoleTracker;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public LeaderDecider getLeaderDecider() {
        return this.leaderDecider;
    }

    public ITask getMetricsEmittingShardSyncTask() {
        return this.metricsEmittingShardSyncTask;
    }

    public ScheduledExecutorService getShardSyncThreadPool() {
        return this.shardSyncThreadPool;
    }

    public ILeaseManager<KinesisClientLease> getLeaseManager() {
        return this.leaseManager;
    }

    public IKinesisProxy getKinesisProxy() {
        return this.kinesisProxy;
    }

    public boolean isAuditorMode() {
        return this.isAuditorMode;
    }

    public long getPeriodicShardSyncIntervalMillis() {
        return this.periodicShardSyncIntervalMillis;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public IMetricsFactory getMetricsFactory() {
        return this.metricsFactory;
    }

    public int getLeasesRecoveryAuditorInconsistencyConfidenceThreshold() {
        return this.leasesRecoveryAuditorInconsistencyConfidenceThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeriodicShardSyncManager)) {
            return false;
        }
        PeriodicShardSyncManager other = (PeriodicShardSyncManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashRangeHoleTracker this$hashRangeHoleTracker = this.getHashRangeHoleTracker();
        HashRangeHoleTracker other$hashRangeHoleTracker = other.getHashRangeHoleTracker();
        if (this$hashRangeHoleTracker == null ? other$hashRangeHoleTracker != null : !this$hashRangeHoleTracker.equals(other$hashRangeHoleTracker)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        LeaderDecider this$leaderDecider = this.getLeaderDecider();
        LeaderDecider other$leaderDecider = other.getLeaderDecider();
        if (this$leaderDecider == null ? other$leaderDecider != null : !this$leaderDecider.equals(other$leaderDecider)) {
            return false;
        }
        ITask this$metricsEmittingShardSyncTask = this.getMetricsEmittingShardSyncTask();
        ITask other$metricsEmittingShardSyncTask = other.getMetricsEmittingShardSyncTask();
        if (this$metricsEmittingShardSyncTask == null ? other$metricsEmittingShardSyncTask != null : !this$metricsEmittingShardSyncTask.equals(other$metricsEmittingShardSyncTask)) {
            return false;
        }
        ScheduledExecutorService this$shardSyncThreadPool = this.getShardSyncThreadPool();
        ScheduledExecutorService other$shardSyncThreadPool = other.getShardSyncThreadPool();
        if (this$shardSyncThreadPool == null ? other$shardSyncThreadPool != null : !this$shardSyncThreadPool.equals(other$shardSyncThreadPool)) {
            return false;
        }
        ILeaseManager<KinesisClientLease> this$leaseManager = this.getLeaseManager();
        ILeaseManager<KinesisClientLease> other$leaseManager = other.getLeaseManager();
        if (this$leaseManager == null ? other$leaseManager != null : !this$leaseManager.equals(other$leaseManager)) {
            return false;
        }
        IKinesisProxy this$kinesisProxy = this.getKinesisProxy();
        IKinesisProxy other$kinesisProxy = other.getKinesisProxy();
        if (this$kinesisProxy == null ? other$kinesisProxy != null : !this$kinesisProxy.equals(other$kinesisProxy)) {
            return false;
        }
        if (this.isAuditorMode() != other.isAuditorMode()) {
            return false;
        }
        if (this.getPeriodicShardSyncIntervalMillis() != other.getPeriodicShardSyncIntervalMillis()) {
            return false;
        }
        if (this.isRunning() != other.isRunning()) {
            return false;
        }
        IMetricsFactory this$metricsFactory = this.getMetricsFactory();
        IMetricsFactory other$metricsFactory = other.getMetricsFactory();
        if (this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory)) {
            return false;
        }
        return this.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold() == other.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PeriodicShardSyncManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashRangeHoleTracker $hashRangeHoleTracker = this.getHashRangeHoleTracker();
        result = result * 59 + ($hashRangeHoleTracker == null ? 43 : $hashRangeHoleTracker.hashCode());
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        LeaderDecider $leaderDecider = this.getLeaderDecider();
        result = result * 59 + ($leaderDecider == null ? 43 : $leaderDecider.hashCode());
        ITask $metricsEmittingShardSyncTask = this.getMetricsEmittingShardSyncTask();
        result = result * 59 + ($metricsEmittingShardSyncTask == null ? 43 : $metricsEmittingShardSyncTask.hashCode());
        ScheduledExecutorService $shardSyncThreadPool = this.getShardSyncThreadPool();
        result = result * 59 + ($shardSyncThreadPool == null ? 43 : $shardSyncThreadPool.hashCode());
        ILeaseManager<KinesisClientLease> $leaseManager = this.getLeaseManager();
        result = result * 59 + ($leaseManager == null ? 43 : $leaseManager.hashCode());
        IKinesisProxy $kinesisProxy = this.getKinesisProxy();
        result = result * 59 + ($kinesisProxy == null ? 43 : $kinesisProxy.hashCode());
        result = result * 59 + (this.isAuditorMode() ? 79 : 97);
        long $periodicShardSyncIntervalMillis = this.getPeriodicShardSyncIntervalMillis();
        result = result * 59 + (int)($periodicShardSyncIntervalMillis >>> 32 ^ $periodicShardSyncIntervalMillis);
        result = result * 59 + (this.isRunning() ? 79 : 97);
        IMetricsFactory $metricsFactory = this.getMetricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        result = result * 59 + this.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold();
        return result;
    }

    private static class HashKeyRangeComparator
    implements Comparator<KinesisClientLease>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private HashKeyRangeComparator() {
        }

        @Override
        public int compare(KinesisClientLease lease, KinesisClientLease otherLease) {
            Validate.notNull((Object)lease);
            Validate.notNull((Object)otherLease);
            Validate.notNull((Object)lease.getHashKeyRange());
            Validate.notNull((Object)otherLease.getHashKeyRange());
            return ComparisonChain.start().compare((Comparable)lease.getHashKeyRange().startingHashKey(), (Comparable)otherLease.getHashKeyRange().startingHashKey()).compare((Comparable)lease.getHashKeyRange().endingHashKey(), (Comparable)otherLease.getHashKeyRange().endingHashKey()).result();
        }
    }

    private class HashRangeHoleTracker {
        private HashRangeHole hashRangeHole;
        private Integer numConsecutiveHoles;

        private HashRangeHoleTracker() {
        }

        public boolean hashHighConfidenceOfHoleWith(@NonNull HashRangeHole hashRangeHole) {
            if (hashRangeHole == null) {
                throw new NullPointerException("hashRangeHole");
            }
            if (hashRangeHole.equals(this.hashRangeHole)) {
                HashRangeHoleTracker hashRangeHoleTracker = this;
                hashRangeHoleTracker.numConsecutiveHoles = hashRangeHoleTracker.numConsecutiveHoles + 1;
            } else {
                this.hashRangeHole = hashRangeHole;
                this.numConsecutiveHoles = 1;
            }
            return this.numConsecutiveHoles >= PeriodicShardSyncManager.this.leasesRecoveryAuditorInconsistencyConfidenceThreshold;
        }

        public void reset() {
            this.hashRangeHole = null;
            this.numConsecutiveHoles = 0;
        }

        public Integer getNumConsecutiveHoles() {
            return this.numConsecutiveHoles;
        }
    }

    private static final class HashRangeHole {
        private final HashKeyRangeForLease hashRangeAtStartOfPossibleHole;
        private final HashKeyRangeForLease hashRangeAtEndOfPossibleHole;

        HashRangeHole() {
            this.hashRangeAtEndOfPossibleHole = null;
            this.hashRangeAtStartOfPossibleHole = null;
        }

        HashRangeHole(HashKeyRangeForLease hashRangeAtStartOfPossibleHole, HashKeyRangeForLease hashRangeAtEndOfPossibleHole) {
            this.hashRangeAtStartOfPossibleHole = hashRangeAtStartOfPossibleHole;
            this.hashRangeAtEndOfPossibleHole = hashRangeAtEndOfPossibleHole;
        }

        public HashKeyRangeForLease getHashRangeAtStartOfPossibleHole() {
            return this.hashRangeAtStartOfPossibleHole;
        }

        public HashKeyRangeForLease getHashRangeAtEndOfPossibleHole() {
            return this.hashRangeAtEndOfPossibleHole;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashRangeHole)) {
                return false;
            }
            HashRangeHole other = (HashRangeHole)o;
            HashKeyRangeForLease this$hashRangeAtStartOfPossibleHole = this.getHashRangeAtStartOfPossibleHole();
            HashKeyRangeForLease other$hashRangeAtStartOfPossibleHole = other.getHashRangeAtStartOfPossibleHole();
            if (this$hashRangeAtStartOfPossibleHole == null ? other$hashRangeAtStartOfPossibleHole != null : !((Object)this$hashRangeAtStartOfPossibleHole).equals(other$hashRangeAtStartOfPossibleHole)) {
                return false;
            }
            HashKeyRangeForLease this$hashRangeAtEndOfPossibleHole = this.getHashRangeAtEndOfPossibleHole();
            HashKeyRangeForLease other$hashRangeAtEndOfPossibleHole = other.getHashRangeAtEndOfPossibleHole();
            return !(this$hashRangeAtEndOfPossibleHole == null ? other$hashRangeAtEndOfPossibleHole != null : !((Object)this$hashRangeAtEndOfPossibleHole).equals(other$hashRangeAtEndOfPossibleHole));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HashKeyRangeForLease $hashRangeAtStartOfPossibleHole = this.getHashRangeAtStartOfPossibleHole();
            result = result * 59 + ($hashRangeAtStartOfPossibleHole == null ? 43 : ((Object)$hashRangeAtStartOfPossibleHole).hashCode());
            HashKeyRangeForLease $hashRangeAtEndOfPossibleHole = this.getHashRangeAtEndOfPossibleHole();
            result = result * 59 + ($hashRangeAtEndOfPossibleHole == null ? 43 : ((Object)$hashRangeAtEndOfPossibleHole).hashCode());
            return result;
        }

        public String toString() {
            return "PeriodicShardSyncManager.HashRangeHole(hashRangeAtStartOfPossibleHole=" + this.getHashRangeAtStartOfPossibleHole() + ", hashRangeAtEndOfPossibleHole=" + this.getHashRangeAtEndOfPossibleHole() + ")";
        }
    }

    @VisibleForTesting
    static final class ShardSyncResponse {
        private final boolean shouldDoShardSync;
        private final boolean isHoleDetected;
        private final String reasonForDecision;

        @ConstructorProperties(value={"shouldDoShardSync", "isHoleDetected", "reasonForDecision"})
        public ShardSyncResponse(boolean shouldDoShardSync, boolean isHoleDetected, String reasonForDecision) {
            this.shouldDoShardSync = shouldDoShardSync;
            this.isHoleDetected = isHoleDetected;
            this.reasonForDecision = reasonForDecision;
        }

        public boolean shouldDoShardSync() {
            return this.shouldDoShardSync;
        }

        public boolean isHoleDetected() {
            return this.isHoleDetected;
        }

        public String reasonForDecision() {
            return this.reasonForDecision;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShardSyncResponse)) {
                return false;
            }
            ShardSyncResponse other = (ShardSyncResponse)o;
            if (this.shouldDoShardSync() != other.shouldDoShardSync()) {
                return false;
            }
            if (this.isHoleDetected() != other.isHoleDetected()) {
                return false;
            }
            String this$reasonForDecision = this.reasonForDecision();
            String other$reasonForDecision = other.reasonForDecision();
            return !(this$reasonForDecision == null ? other$reasonForDecision != null : !this$reasonForDecision.equals(other$reasonForDecision));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.shouldDoShardSync() ? 79 : 97);
            result = result * 59 + (this.isHoleDetected() ? 79 : 97);
            String $reasonForDecision = this.reasonForDecision();
            result = result * 59 + ($reasonForDecision == null ? 43 : $reasonForDecision.hashCode());
            return result;
        }

        public String toString() {
            return "PeriodicShardSyncManager.ShardSyncResponse(shouldDoShardSync=" + this.shouldDoShardSync() + ", isHoleDetected=" + this.isHoleDetected() + ", reasonForDecision=" + this.reasonForDecision() + ")";
        }
    }
}

