/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactionalobjects;

import org.multiverse.api.Lock;
import org.multiverse.api.LockMode;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.exceptions.PanicError;
import org.multiverse.api.exceptions.TxnMandatoryException;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.GammaObject;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.utils.ToolUnsafe;
import sun.misc.Unsafe;

public abstract class AbstractGammaObject
implements GammaObject,
Lock {
    public static final long MASK_OREC_EXCLUSIVELOCK = Long.MIN_VALUE;
    public static final long MASK_OREC_UPDATELOCK = 0x4000000000000000L;
    public static final long MASK_OREC_READBIASED = 0x2000000000000000L;
    public static final long MASK_OREC_READLOCKS = 0x1FFFFF0000000000L;
    public static final long MASK_OREC_SURPLUS = 0xFFFFFFFE00L;
    public static final long MASK_OREC_READONLY_COUNT = 1023L;
    protected static final Unsafe ___unsafe = ToolUnsafe.getUnsafe();
    protected static final long listenersOffset;
    protected static final long valueOffset;
    public final GammaStm stm;
    public volatile Listeners listeners;
    public volatile long version;
    public volatile long orec;
    protected int identityHashCode;
    private final int readBiasedThreshold;

    public AbstractGammaObject(GammaStm stm) {
        assert (stm != null);
        this.stm = stm;
        this.readBiasedThreshold = stm.readBiasedThreshold;
    }

    @Override
    public final long getVersion() {
        return this.version;
    }

    @Override
    public final GammaStm getStm() {
        return this.stm;
    }

    @Override
    public final Lock getLock() {
        return this;
    }

    public final Listeners ___removeListenersAfterWrite() {
        Listeners removedListeners;
        if (this.listeners == null) {
            return null;
        }
        while (!___unsafe.compareAndSwapObject(this, listenersOffset, removedListeners = this.listeners, null)) {
        }
        return removedListeners;
    }

    @Override
    public final int identityHashCode() {
        int tmp = this.identityHashCode;
        if (tmp != 0) {
            return tmp;
        }
        this.identityHashCode = tmp = System.identityHashCode(this);
        return tmp;
    }

    public final int atomicGetLockModeAsInt() {
        long current = this.orec;
        if (AbstractGammaObject.hasExclusiveLock(current)) {
            return 3;
        }
        if (AbstractGammaObject.hasWriteLock(current)) {
            return 2;
        }
        if (AbstractGammaObject.getReadLockCount(current) > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public final LockMode atomicGetLockMode() {
        switch (this.atomicGetLockModeAsInt()) {
            case 0: {
                return LockMode.None;
            }
            case 1: {
                return LockMode.Read;
            }
            case 2: {
                return LockMode.Write;
            }
            case 3: {
                return LockMode.Exclusive;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final LockMode getLockMode() {
        GammaTxn tx = (GammaTxn)TxnThreadLocal.getThreadLocalTxn();
        if (tx == null) {
            throw new TxnMandatoryException();
        }
        return this.getLockMode(tx);
    }

    @Override
    public final LockMode getLockMode(Txn tx) {
        return this.getLockMode((GammaTxn)tx);
    }

    public final LockMode getLockMode(GammaTxn tx) {
        Tranlocal tranlocal = tx.locate((BaseGammaTxnRef)this);
        if (tranlocal == null) {
            return LockMode.None;
        }
        switch (tranlocal.getLockMode()) {
            case 0: {
                return LockMode.None;
            }
            case 1: {
                return LockMode.Read;
            }
            case 2: {
                return LockMode.Write;
            }
            case 3: {
                return LockMode.Exclusive;
            }
        }
        throw new IllegalStateException();
    }

    private static void yieldIfNeeded(int remainingSpins) {
        if (remainingSpins % SPIN_YIELD == 0 && remainingSpins > 0) {
            Thread.yield();
        }
    }

    public final boolean waitForExclusiveLockToBecomeFree(int spinCount) {
        do {
            if (AbstractGammaObject.hasExclusiveLock(this.orec)) continue;
            return true;
        } while (--spinCount >= 0);
        return false;
    }

    public final boolean hasWriteLock() {
        return AbstractGammaObject.hasWriteLock(this.orec);
    }

    public final boolean hasExclusiveLock() {
        return AbstractGammaObject.hasExclusiveLock(this.orec);
    }

    public final int getReadBiasedThreshold() {
        return this.readBiasedThreshold;
    }

    public final long getSurplus() {
        return AbstractGammaObject.getSurplus(this.orec);
    }

    public final boolean isReadBiased() {
        return AbstractGammaObject.isReadBiased(this.orec);
    }

    public final int getReadonlyCount() {
        return AbstractGammaObject.getReadonlyCount(this.orec);
    }

    public final int getReadLockCount() {
        return AbstractGammaObject.getReadLockCount(this.orec);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int arrive(int spinCount) {
        do {
            boolean isReadBiased;
            long surplus;
            long current;
            block7: {
                if (AbstractGammaObject.hasExclusiveLock(current = this.orec)) {
                    AbstractGammaObject.yieldIfNeeded(--spinCount);
                    continue;
                }
                surplus = AbstractGammaObject.getSurplus(current);
                isReadBiased = AbstractGammaObject.isReadBiased(current);
                if (isReadBiased) {
                    if (surplus == 0L) {
                        surplus = 1L;
                        break block7;
                    } else {
                        if (surplus == 1L) {
                            return 3;
                        }
                        throw new PanicError("Surplus for a readbiased orec can never be larger than 1");
                    }
                }
                ++surplus;
            }
            long next = AbstractGammaObject.setSurplus(current, surplus);
            if (!___unsafe.compareAndSwapLong(this, valueOffset, current, next)) continue;
            int result = 1;
            if (isReadBiased) {
                result += 2;
            }
            return result;
        } while (spinCount >= 0);
        return 0;
    }

    public final int upgradeReadLock(int spinCount, boolean exclusiveLock) {
        do {
            long current;
            int readLockCount;
            if ((readLockCount = AbstractGammaObject.getReadLockCount(current = this.orec)) == 0) {
                throw new PanicError(String.format("Can't update from readlock to %s if no readlocks are acquired", exclusiveLock ? "exclusiveLock" : "writeLock"));
            }
            if (readLockCount > 1) {
                AbstractGammaObject.yieldIfNeeded(--spinCount);
                continue;
            }
            long next = AbstractGammaObject.setReadLockCount(current, 0L);
            next = exclusiveLock ? AbstractGammaObject.setExclusiveLock(next, true) : AbstractGammaObject.setWriteLock(next, true);
            if (!___unsafe.compareAndSwapLong(this, valueOffset, current, next)) continue;
            int result = 1;
            if (exclusiveLock && (AbstractGammaObject.isReadBiased(current) || AbstractGammaObject.getSurplus(current) > 1L)) {
                result += 4;
            }
            return result;
        } while (spinCount >= 0);
        return 0;
    }

    public final boolean upgradeWriteLock() {
        long next;
        long current;
        do {
            if (AbstractGammaObject.hasExclusiveLock(current = this.orec)) {
                return false;
            }
            if (!AbstractGammaObject.hasWriteLock(current)) {
                throw new PanicError("WriteLock is not acquired");
            }
            next = AbstractGammaObject.setExclusiveLock(current, true);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = AbstractGammaObject.setWriteLock(next, false)));
        return AbstractGammaObject.isReadBiased(current) || AbstractGammaObject.getSurplus(current) > 1L;
    }

    public final int arriveAndLock(int spinCount, int lockMode) {
        assert (lockMode != 0);
        do {
            long currentSurplus;
            boolean locked;
            long current = this.orec;
            boolean bl = locked = lockMode == 1 ? AbstractGammaObject.hasWriteOrExclusiveLock(current) : AbstractGammaObject.hasAnyLock(current);
            if (locked) {
                AbstractGammaObject.yieldIfNeeded(--spinCount);
                continue;
            }
            long surplus = currentSurplus = AbstractGammaObject.getSurplus(current);
            boolean isReadBiased = AbstractGammaObject.isReadBiased(current);
            if (isReadBiased) {
                if (surplus == 0L) {
                    surplus = 1L;
                } else if (surplus > 1L) {
                    throw new PanicError("Surplus is larger than 1 and orec is readbiased: " + AbstractGammaObject.toOrecString(current));
                }
            } else {
                ++surplus;
            }
            long next = AbstractGammaObject.setSurplus(current, surplus);
            if (lockMode == 3) {
                next = AbstractGammaObject.setExclusiveLock(next, true);
            } else if (lockMode == 1) {
                next = AbstractGammaObject.setReadLockCount(next, AbstractGammaObject.getReadLockCount(current) + 1);
            } else if (lockMode == 2) {
                next = AbstractGammaObject.setWriteLock(next, true);
            }
            if (!___unsafe.compareAndSwapLong(this, valueOffset, current, next)) continue;
            int result = 1;
            if (isReadBiased) {
                result += 2;
            }
            if (lockMode == 3 && currentSurplus > 0L) {
                result += 4;
            }
            return result;
        } while (spinCount >= 0);
        return 0;
    }

    public final int arriveAndExclusiveLock(int spinCount) {
        do {
            long currentSurplus;
            long current;
            if (AbstractGammaObject.hasAnyLock(current = this.orec)) {
                AbstractGammaObject.yieldIfNeeded(--spinCount);
                continue;
            }
            long surplus = currentSurplus = AbstractGammaObject.getSurplus(current);
            boolean isReadBiased = AbstractGammaObject.isReadBiased(current);
            if (isReadBiased) {
                if (surplus == 0L) {
                    surplus = 1L;
                } else if (surplus > 1L) {
                    throw new PanicError("Surplus is larger than 2: " + AbstractGammaObject.toOrecString(current));
                }
            } else {
                ++surplus;
            }
            long next = AbstractGammaObject.setSurplus(current, surplus);
            next = AbstractGammaObject.setExclusiveLock(next, true);
            if (!___unsafe.compareAndSwapLong(this, valueOffset, current, next)) continue;
            int result = 1;
            if (isReadBiased) {
                result += 2;
            }
            if (currentSurplus > 0L) {
                result += 4;
            }
            return result;
        } while (spinCount >= 0);
        return 0;
    }

    public final int lockAfterArrive(int spinCount, int lockMode) {
        assert (lockMode != 0);
        do {
            boolean locked;
            long current;
            if (AbstractGammaObject.isReadBiased(current = this.orec)) {
                throw new PanicError("Orec is readbiased " + AbstractGammaObject.toOrecString(current));
            }
            boolean bl = locked = lockMode == 1 ? AbstractGammaObject.hasWriteOrExclusiveLock(current) : AbstractGammaObject.hasAnyLock(current);
            if (locked) {
                AbstractGammaObject.yieldIfNeeded(--spinCount);
                continue;
            }
            long currentSurplus = AbstractGammaObject.getSurplus(current);
            if (currentSurplus == 0L) {
                throw new PanicError("There is no surplus (so if it didn't do a read before)" + AbstractGammaObject.toOrecString(current));
            }
            long next = current;
            next = lockMode == 1 ? AbstractGammaObject.setReadLockCount(next, AbstractGammaObject.getReadLockCount(current) + 1) : (lockMode == 3 ? AbstractGammaObject.setExclusiveLock(next, true) : AbstractGammaObject.setWriteLock(current, true));
            if (!___unsafe.compareAndSwapLong(this, valueOffset, current, next)) continue;
            int result = 1;
            if (lockMode == 3 && currentSurplus > 1L) {
                result += 4;
            }
            return result;
        } while (spinCount >= 0);
        return 0;
    }

    public final void departAfterReading() {
        long surplus;
        long next;
        long current;
        do {
            if ((surplus = AbstractGammaObject.getSurplus(current = this.orec)) == 0L) {
                throw new PanicError("There is no surplus " + AbstractGammaObject.toOrecString(current));
            }
            boolean isReadBiased = AbstractGammaObject.isReadBiased(current);
            if (isReadBiased) {
                throw new PanicError("Orec is readbiased " + AbstractGammaObject.toOrecString(current));
            }
            int readonlyCount = AbstractGammaObject.getReadonlyCount(current);
            if (readonlyCount < this.readBiasedThreshold) {
                ++readonlyCount;
            }
            if (surplus <= 1L && AbstractGammaObject.hasAnyLock(current)) {
                throw new PanicError("There is not enough surplus " + AbstractGammaObject.toOrecString(current));
            }
            boolean hasExclusiveLock = AbstractGammaObject.hasExclusiveLock(current);
            if (!hasExclusiveLock && --surplus == 0L && readonlyCount == this.readBiasedThreshold) {
                isReadBiased = true;
                readonlyCount = 0;
            }
            next = AbstractGammaObject.setIsReadBiased(current, isReadBiased);
            next = AbstractGammaObject.setReadonlyCount(next, readonlyCount);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = AbstractGammaObject.setSurplus(next, surplus)));
    }

    public final void departAfterReadingAndUnlock() {
        long surplus;
        long next;
        long current;
        do {
            if ((surplus = AbstractGammaObject.getSurplus(current = this.orec)) == 0L) {
                throw new PanicError("There is no surplus: " + AbstractGammaObject.toOrecString(current));
            }
            int readLockCount = AbstractGammaObject.getReadLockCount(current);
            if (readLockCount == 0 && !AbstractGammaObject.hasWriteOrExclusiveLock(current)) {
                throw new PanicError("No Lock acquired " + AbstractGammaObject.toOrecString(current));
            }
            boolean isReadBiased = AbstractGammaObject.isReadBiased(current);
            if (isReadBiased) {
                throw new PanicError("Orec is readbiased " + AbstractGammaObject.toOrecString(current));
            }
            int readonlyCount = AbstractGammaObject.getReadonlyCount(current);
            --surplus;
            if (readonlyCount < this.readBiasedThreshold) {
                ++readonlyCount;
            }
            if (surplus == 0L && readonlyCount == this.readBiasedThreshold) {
                isReadBiased = true;
                readonlyCount = 0;
            }
            next = current;
            if (readLockCount > 0) {
                next = AbstractGammaObject.setReadLockCount(next, readLockCount - 1);
            } else {
                next = AbstractGammaObject.setExclusiveLock(next, false);
                next = AbstractGammaObject.setWriteLock(next, false);
            }
            next = AbstractGammaObject.setIsReadBiased(next, isReadBiased);
            next = AbstractGammaObject.setReadonlyCount(next, readonlyCount);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = AbstractGammaObject.setSurplus(next, surplus)));
    }

    public final void departAfterUpdateAndUnlock() {
        long surplus;
        long next;
        long current;
        do {
            if (!AbstractGammaObject.hasExclusiveLock(current = this.orec)) {
                throw new PanicError("Can't departAfterUpdateAndUnlock if the commit lock is not acquired " + AbstractGammaObject.toOrecString(current));
            }
            surplus = AbstractGammaObject.getSurplus(current);
            if (surplus == 0L) {
                throw new PanicError("Can't departAfterUpdateAndUnlock is there is no surplus " + AbstractGammaObject.toOrecString(current));
            }
            if (AbstractGammaObject.isReadBiased(current)) {
                if (surplus > 1L) {
                    throw new PanicError("The surplus can never be larger than 1 if readBiased " + AbstractGammaObject.toOrecString(current));
                }
                surplus = 0L;
            } else {
                --surplus;
            }
            if (surplus != 0L) continue;
            this.orec = 0L;
            return;
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = AbstractGammaObject.setSurplus(0L, surplus)));
    }

    public final void departAfterFailureAndUnlock() {
        long next;
        long current;
        do {
            int lockMode;
            if ((lockMode = AbstractGammaObject.hasWriteOrExclusiveLock(current = this.orec) ? -1 : AbstractGammaObject.getReadLockCount(current)) == 0) {
                throw new PanicError("No lock was not acquired " + AbstractGammaObject.toOrecString(current));
            }
            long surplus = AbstractGammaObject.getSurplus(current);
            if (surplus == 0L) {
                throw new PanicError("There is no surplus " + AbstractGammaObject.toOrecString(current));
            }
            if (!AbstractGammaObject.isReadBiased(current)) {
                --surplus;
            }
            next = AbstractGammaObject.setSurplus(current, surplus);
            if (lockMode == -1) {
                next = AbstractGammaObject.setExclusiveLock(next, false);
                next = AbstractGammaObject.setWriteLock(next, false);
                continue;
            }
            next = AbstractGammaObject.setReadLockCount(next, lockMode - 1);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next));
    }

    public final void departAfterFailure() {
        long surplus;
        long next;
        long current;
        do {
            if (AbstractGammaObject.isReadBiased(current = this.orec)) {
                throw new PanicError("Orec is readbiased:" + AbstractGammaObject.toOrecString(current));
            }
            surplus = AbstractGammaObject.getSurplus(current);
            if (AbstractGammaObject.hasExclusiveLock(current)) {
                if (surplus >= 2L) continue;
                throw new PanicError("there must be at least 2 readers, the thread that acquired the lock, and the calling thread " + AbstractGammaObject.toOrecString(current));
            }
            if (surplus != 0L) continue;
            throw new PanicError("There is no surplus " + AbstractGammaObject.toOrecString(current));
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next = AbstractGammaObject.setSurplus(current, --surplus)));
    }

    public final void unlockByUnregistered() {
        long next;
        long current;
        do {
            if (!AbstractGammaObject.isReadBiased(current = this.orec)) {
                throw new PanicError("Can't ___unlockByReadBiased when it is not readbiased " + AbstractGammaObject.toOrecString(current));
            }
            int lockMode = AbstractGammaObject.hasWriteOrExclusiveLock(current) ? -1 : AbstractGammaObject.getReadLockCount(current);
            if (lockMode == 0) {
                throw new PanicError("No Lock " + AbstractGammaObject.toOrecString(current));
            }
            if (AbstractGammaObject.getSurplus(current) > 1L) {
                throw new PanicError("Surplus for readbiased orec larger than 1 " + AbstractGammaObject.toOrecString(current));
            }
            next = current;
            if (lockMode > 0) {
                next = AbstractGammaObject.setReadLockCount(next, lockMode - 1);
                continue;
            }
            next = AbstractGammaObject.setExclusiveLock(next, false);
            next = AbstractGammaObject.setWriteLock(next, false);
        } while (!___unsafe.compareAndSwapLong(this, valueOffset, current, next));
    }

    public final String ___toOrecString() {
        return AbstractGammaObject.toOrecString(this.orec);
    }

    public static long setReadLockCount(long value, long readLockCount) {
        return value & 0xE00000FFFFFFFFFFL | readLockCount << 40;
    }

    public static int getReadLockCount(long value) {
        return (int)((value & 0x1FFFFF0000000000L) >> 40);
    }

    public static long setExclusiveLock(long value, boolean exclusiveLock) {
        return value & Long.MAX_VALUE | (exclusiveLock ? 1L : 0L) << 63;
    }

    public static boolean hasWriteOrExclusiveLock(long value) {
        return (value & 0xC000000000000000L) != 0L;
    }

    public static boolean hasAnyLock(long value) {
        return (value & 0xDFFFFF0000000000L) != 0L;
    }

    public static boolean hasExclusiveLock(long value) {
        return (value & Long.MIN_VALUE) != 0L;
    }

    public static boolean isReadBiased(long value) {
        return (value & 0x2000000000000000L) != 0L;
    }

    public static long setIsReadBiased(long value, boolean isReadBiased) {
        return value & 0xDFFFFFFFFFFFFFFFL | (isReadBiased ? 1L : 0L) << 61;
    }

    public static boolean hasWriteLock(long value) {
        return (value & 0x4000000000000000L) != 0L;
    }

    public static long setWriteLock(long value, boolean updateLock) {
        return value & 0xBFFFFFFFFFFFFFFFL | (updateLock ? 1L : 0L) << 62;
    }

    public static int getReadonlyCount(long value) {
        return (int)(value & 0x3FFL);
    }

    public static long setReadonlyCount(long value, int readonlyCount) {
        return value & 0xFFFFFFFFFFFFFC00L | (long)readonlyCount;
    }

    public static long setSurplus(long value, long surplus) {
        return value & 0xFFFFFF00000001FFL | surplus << 10;
    }

    public static long getSurplus(long value) {
        return (value & 0xFFFFFFFE00L) >> 10;
    }

    private static String toOrecString(long value) {
        return String.format("Orec(hasExclusiveLock=%s, hasWriteLock=%s, readLocks=%s, surplus=%s, isReadBiased=%s, readonlyCount=%s)", AbstractGammaObject.hasExclusiveLock(value), AbstractGammaObject.hasWriteLock(value), AbstractGammaObject.getReadLockCount(value), AbstractGammaObject.getSurplus(value), AbstractGammaObject.isReadBiased(value), AbstractGammaObject.getReadonlyCount(value));
    }

    static {
        try {
            listenersOffset = ___unsafe.objectFieldOffset(AbstractGammaObject.class.getDeclaredField("listeners"));
            valueOffset = ___unsafe.objectFieldOffset(AbstractGammaObject.class.getDeclaredField("orec"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

