/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.impl;

import groovyx.gpars.dataflow.BindErrorListener;
import groovyx.gpars.dataflow.DataflowChannelListener;
import groovyx.gpars.dataflow.impl.BindErrorDistributor;
import groovyx.gpars.dataflow.impl.BindErrorListenerManager;
import groovyx.gpars.dataflow.impl.DataflowChannelEventDistributor;
import groovyx.gpars.dataflow.impl.DataflowChannelEventListenerManager;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DataflowChannelEventOrchestrator<T>
implements DataflowChannelEventListenerManager<T>,
BindErrorListenerManager<T>,
DataflowChannelEventDistributor<T>,
BindErrorDistributor<T> {
    private final Collection<DataflowChannelListener<T>> listeners = new CopyOnWriteArrayList<DataflowChannelListener<T>>();
    private final Collection<BindErrorListener<T>> BindErrorListener = new CopyOnWriteArrayList<BindErrorListener<T>>();

    @Override
    public void addDataflowChannelListener(DataflowChannelListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addAllDataflowChannelListeners(Collection<DataflowChannelListener<T>> listeners) {
        this.listeners.addAll(listeners);
    }

    @Override
    public void removeDataflowChannelListener(DataflowChannelListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<DataflowChannelListener<T>> getListeners() {
        return this.listeners;
    }

    @Override
    public void fireOnMessage(T message) {
        for (DataflowChannelListener<T> listener : this.listeners) {
            listener.onMessage(message);
        }
    }

    @Override
    public void addBindErrorListener(BindErrorListener<T> listener) {
        this.BindErrorListener.add(listener);
    }

    @Override
    public void addAllBindErrorListeners(Collection<BindErrorListener<T>> listeners) {
        this.BindErrorListener.addAll(listeners);
    }

    @Override
    public void removeBindErrorListener(BindErrorListener<T> listener) {
        this.BindErrorListener.remove(listener);
    }

    @Override
    public Collection<BindErrorListener<T>> getBindErrorListeners() {
        return this.BindErrorListener;
    }

    @Override
    public void fireBindError(T oldValue, T failedValue, boolean uniqueBind) {
        for (BindErrorListener<T> listener : this.BindErrorListener) {
            listener.onBindError(oldValue, failedValue, uniqueBind);
        }
    }

    @Override
    public void fireBindError(T oldValue, Throwable failedError) {
        for (BindErrorListener<T> listener : this.BindErrorListener) {
            listener.onBindError(oldValue, failedError);
        }
    }

    @Override
    public void fireBindError(Throwable oldError, T failedValue, boolean uniqueBind) {
        for (BindErrorListener<T> listener : this.BindErrorListener) {
            listener.onBindError(oldError, failedValue, uniqueBind);
        }
    }

    @Override
    public void fireBindError(Throwable oldError, Throwable failedError) {
        for (BindErrorListener<T> listener : this.BindErrorListener) {
            listener.onBindError(oldError, failedError);
        }
    }
}

