/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package org.apache.grails.buildsrc

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.file.Directory

@CompileStatic
class GradleUtils {

    static Directory findRootGrailsCoreDir(Project project) {
        def rootLayout = project.rootProject.layout
        // .github / .git related directories are purged from source releases, so use the .asf.yaml as an indicator of
        // the parent directory
        if (rootLayout.projectDirectory.file('.asf.yaml').asFile.exists()) {
            return rootLayout.projectDirectory
        }

        // we currently only nest 1 project level deep
        rootLayout.projectDirectory.dir('../')
    }

    static <T> T lookupProperty(Project project, String name, T defaultValue = null) {
        project.findProperty(name) as T ?: defaultValue
    }
}
