/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.append;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.store.file.compact.CompactFutureManager;
import org.apache.flink.table.store.file.compact.CompactResult;
import org.apache.flink.table.store.file.compact.CompactTask;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.DataFilePathFactory;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.util.Preconditions;

public class AppendOnlyCompactManager
extends CompactFutureManager {
    private final ExecutorService executor;
    private final LinkedList<DataFileMeta> toCompact;
    private final int minFileNum;
    private final int maxFileNum;
    private final long targetFileSize;
    private final CompactRewriter rewriter;
    private final DataFilePathFactory pathFactory;

    public AppendOnlyCompactManager(ExecutorService executor, LinkedList<DataFileMeta> toCompact, int minFileNum, int maxFileNum, long targetFileSize, CompactRewriter rewriter, DataFilePathFactory pathFactory) {
        this.executor = executor;
        this.toCompact = toCompact;
        this.minFileNum = minFileNum;
        this.maxFileNum = maxFileNum;
        this.targetFileSize = targetFileSize;
        this.rewriter = rewriter;
        this.pathFactory = pathFactory;
    }

    @Override
    public void triggerCompaction(boolean fullCompaction) {
        if (fullCompaction) {
            this.triggerFullCompaction();
        } else {
            this.triggerCompactionWithBestEffort();
        }
    }

    private void triggerFullCompaction() {
        Preconditions.checkState(this.taskFuture == null, "A compaction task is still running while the user forces a new compaction. This is unexpected.");
        this.taskFuture = this.executor.submit(new IterativeCompactTask(this.toCompact, this.targetFileSize, this.minFileNum, this.maxFileNum, this.rewriter, this.pathFactory));
    }

    private void triggerCompactionWithBestEffort() {
        if (this.taskFuture != null) {
            return;
        }
        this.pickCompactBefore().ifPresent(inputs -> {
            this.taskFuture = this.executor.submit(new AutoCompactTask((List<DataFileMeta>)inputs, this.rewriter));
        });
    }

    @Override
    public boolean shouldWaitCompaction() {
        return false;
    }

    @Override
    public void addNewFile(DataFileMeta file) {
        this.toCompact.add(file);
    }

    @Override
    public Optional<CompactResult> getCompactionResult(boolean blocking) throws ExecutionException, InterruptedException {
        Optional<CompactResult> result = this.innerGetCompactionResult(blocking);
        result.ifPresent(r -> {
            DataFileMeta lastFile;
            if (!r.after().isEmpty() && (lastFile = r.after().get(r.after().size() - 1)).fileSize() < this.targetFileSize) {
                this.toCompact.offerFirst(lastFile);
            }
        });
        return result;
    }

    @VisibleForTesting
    Optional<List<DataFileMeta>> pickCompactBefore() {
        return AppendOnlyCompactManager.pick(this.toCompact, this.targetFileSize, this.minFileNum, this.maxFileNum);
    }

    private static Optional<List<DataFileMeta>> pick(LinkedList<DataFileMeta> toCompact, long targetFileSize, int minFileNum, int maxFileNum) {
        if (toCompact.isEmpty()) {
            return Optional.empty();
        }
        long totalFileSize = 0L;
        int fileNum = 0;
        LinkedList<DataFileMeta> candidates = new LinkedList<DataFileMeta>();
        while (!toCompact.isEmpty()) {
            DataFileMeta file = toCompact.pollFirst();
            candidates.add(file);
            if ((totalFileSize += file.fileSize()) >= targetFileSize && ++fileNum >= minFileNum || fileNum >= maxFileNum) {
                return Optional.of(candidates);
            }
            if (totalFileSize < targetFileSize) continue;
            DataFileMeta removed = (DataFileMeta)candidates.pollFirst();
            assert (removed != null);
            totalFileSize -= removed.fileSize();
            --fileNum;
        }
        toCompact.addAll(candidates);
        return Optional.empty();
    }

    @VisibleForTesting
    LinkedList<DataFileMeta> getToCompact() {
        return this.toCompact;
    }

    private static CompactResult result(final List<DataFileMeta> before, final List<DataFileMeta> after) {
        return new CompactResult(){

            @Override
            public List<DataFileMeta> before() {
                return before;
            }

            @Override
            public List<DataFileMeta> after() {
                return after;
            }
        };
    }

    public static interface CompactRewriter {
        public List<DataFileMeta> rewrite(List<DataFileMeta> var1) throws Exception;
    }

    public static class AutoCompactTask
    extends CompactTask {
        private final CompactRewriter rewriter;

        public AutoCompactTask(List<DataFileMeta> toCompact, CompactRewriter rewriter) {
            super(toCompact);
            this.rewriter = rewriter;
        }

        @Override
        protected CompactResult doCompact(List<DataFileMeta> inputs) throws Exception {
            return AppendOnlyCompactManager.result(inputs, this.rewriter.rewrite(inputs));
        }
    }

    public static class IterativeCompactTask
    extends CompactTask {
        private final long targetFileSize;
        private final int minFileNum;
        private final int maxFileNum;
        private final CompactRewriter rewriter;
        private final DataFilePathFactory factory;

        public IterativeCompactTask(List<DataFileMeta> inputs, long targetFileSize, int minFileNum, int maxFileNum, CompactRewriter rewriter, DataFilePathFactory factory) {
            super(inputs);
            this.targetFileSize = targetFileSize;
            this.minFileNum = minFileNum;
            this.maxFileNum = maxFileNum;
            this.rewriter = rewriter;
            this.factory = factory;
        }

        @Override
        protected CompactResult doCompact(List<DataFileMeta> inputs) throws Exception {
            Optional candidates;
            LinkedList<DataFileMeta> toCompact = new LinkedList<DataFileMeta>(inputs);
            LinkedHashSet compactBefore = new LinkedHashSet();
            ArrayList<DataFileMeta> compactAfter = new ArrayList<DataFileMeta>();
            while (!toCompact.isEmpty() && (candidates = AppendOnlyCompactManager.pick(toCompact, this.targetFileSize, this.minFileNum, this.maxFileNum)).isPresent()) {
                List before = (List)candidates.get();
                compactBefore.addAll(before);
                List<DataFileMeta> after = this.rewriter.rewrite(before);
                compactAfter.addAll(after);
                DataFileMeta lastFile = after.get(after.size() - 1);
                if (lastFile.fileSize() >= this.targetFileSize) continue;
                toCompact.offerFirst(lastFile);
            }
            Iterator afterIterator = compactAfter.iterator();
            while (afterIterator.hasNext()) {
                DataFileMeta file = (DataFileMeta)afterIterator.next();
                if (!compactBefore.contains(file)) continue;
                compactBefore.remove(file);
                afterIterator.remove();
                this.delete(file);
            }
            return AppendOnlyCompactManager.result(new ArrayList(compactBefore), compactAfter);
        }

        @VisibleForTesting
        void delete(DataFileMeta tmpFile) {
            FileUtils.deleteOrWarn(this.factory.toPath(tmpFile.fileName()));
        }
    }
}

