/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.launcher.commands.player;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.util.ResourceUtils;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.commands.player.DefaultPlayerCommand;

public class AdlCommand
extends DefaultPlayerCommand {
    private final String ADT_JAR_PATH = "lib" + File.separatorChar + "adt.jar";
    private final String DESCRIPTOR_TEMPLATE = "flexUnitDescriptor.template";
    private final String DESCRIPTOR_FILE = "flexUnitDescriptor.xml";
    private File precompiledAppDescriptor;

    public File getFileToExecute() {
        if (this.getPrecompiledAppDescriptor() != null) {
            return new File(this.getPrecompiledAppDescriptor().getAbsolutePath());
        }
        return new File(this.getSwf().getParentFile().getAbsolutePath() + File.separatorChar + "flexUnitDescriptor.xml");
    }

    private void createApplicationDescriptor() {
        try {
            URLResource uRLResource = new URLResource(this.getClass().getResource("/flexUnitDescriptor.template"));
            File file = new File(this.getSwf().getParentFile().getAbsolutePath() + File.separatorChar + "flexUnitDescriptor.xml");
            Double d = this.getVersion();
            FilterSet filterSet = new FilterSet();
            filterSet.addFilter("ADL_SWF", this.getSwf().getName());
            filterSet.addFilter("ADT_VERSION", Double.toString(d));
            if (d > 2.0) {
                filterSet.addFilter("VERSION_PROP", "versionNumber");
            } else {
                filterSet.addFilter("VERSION_PROP", "version");
            }
            ResourceUtils.copyResource((Resource)uRLResource, (Resource)new FileResource(file), (FilterSetCollection)new FilterSetCollection(filterSet), null, (boolean)true, (boolean)false, null, null, (Project)this.getProject());
            LoggingUtil.log("Created application descriptor at [" + file.getAbsolutePath() + "]");
        }
        catch (Exception exception) {
            throw new BuildException("Could not create application descriptor");
        }
    }

    private double getVersion() {
        String string = "AIR_VERSION";
        Java java = new Java();
        java.setFork(true);
        java.setFailonerror(true);
        java.setJar(new File(this.getProject().getProperty("FLEX_HOME") + File.separatorChar + this.ADT_JAR_PATH));
        java.setProject(this.getProject());
        java.setDir(this.getProject().getBaseDir());
        java.setOutputproperty(string);
        Commandline.Argument argument = java.createArg();
        argument.setValue("-version");
        java.execute();
        double d = this.parseAdtVersionNumber(this.getProject().getProperty(string));
        LoggingUtil.log("Found AIR version: " + d);
        return d;
    }

    private double parseAdtVersionNumber(String string) {
        double d;
        if (string.startsWith("adt")) {
            int n = string.indexOf("adt version \"");
            d = Double.parseDouble(string.substring(n + 13, n + 16));
        } else {
            d = Double.parseDouble(string.substring(0, 3));
        }
        return d;
    }

    public void prepare() {
        this.getCommandLine().setExecutable(this.generateExecutable());
        this.getCommandLine().addArguments(new String[]{this.getFileToExecute().getAbsolutePath()});
        if (this.getPrecompiledAppDescriptor() == null) {
            this.createApplicationDescriptor();
        }
    }

    private String generateExecutable() {
        return this.getProject().getProperty("FLEX_HOME") + "/bin/" + this.getDefaults().getAdlCommand();
    }

    public File getPrecompiledAppDescriptor() {
        return this.precompiledAppDescriptor;
    }

    public void setPrecompiledAppDescriptor(File file) {
        this.precompiledAppDescriptor = file;
    }
}

