/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.helpers;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.junit4osgi.Helper;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedServiceFactory;

public class IPOJOHelper
extends Helper {
    private BundleContext m_context;
    private OSGiTestCase m_testcase;
    private List m_instances;

    public IPOJOHelper(OSGiTestCase tc) {
        super(tc);
        this.m_testcase = tc;
        this.m_context = this.m_testcase.getBundleContext();
        this.m_instances = new ArrayList();
    }

    public void dispose() {
        for (int i = 0; i < this.m_instances.size(); ++i) {
            ((ComponentInstance)this.m_instances.get(i)).dispose();
        }
        this.m_instances.clear();
    }

    public ComponentInstance getInstanceByName(String name) {
        for (int i = 0; i < this.m_instances.size(); ++i) {
            if (!((ComponentInstance)this.m_instances.get(i)).getInstanceName().equals(name)) continue;
            return (ComponentInstance)this.m_instances.get(i);
        }
        return null;
    }

    public static ComponentInstance createComponentInstance(Bundle bundle, String factoryName, String instanceName) {
        Properties configuration = new Properties();
        configuration.put("instance.name", instanceName);
        return IPOJOHelper.createComponentInstance(bundle, factoryName, (Dictionary)configuration);
    }

    public static ComponentInstance createComponentInstance(Bundle bundle, String factoryName, Dictionary configuration) {
        Factory fact = IPOJOHelper.getFactory(bundle, factoryName);
        if (fact == null) {
            throw new IllegalArgumentException("Cannot find the component factory (" + factoryName + ") in the specified bundle (" + bundle.getSymbolicName() + ").");
        }
        try {
            return fact.createComponentInstance(configuration);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create the component instance with the given configuration:" + e.getMessage());
        }
    }

    public static ComponentInstance createComponentInstance(Bundle bundle, String factoryName, String instanceName, Dictionary configuration) {
        configuration.put("instance.name", instanceName);
        return IPOJOHelper.createComponentInstance(bundle, factoryName, configuration);
    }

    public static ComponentInstance createComponentInstance(ServiceContext serviceContext, String factoryName, String instanceName) {
        Properties configuration = new Properties();
        configuration.put("instance.name", instanceName);
        return IPOJOHelper.createComponentInstance(serviceContext, factoryName, (Dictionary)configuration);
    }

    public static ComponentInstance createComponentInstance(ServiceContext serviceContext, String factoryName, Dictionary configuration) {
        Factory fact = IPOJOHelper.getFactory(serviceContext, factoryName);
        if (fact == null) {
            throw new IllegalArgumentException("Cannot find the component factory (" + factoryName + ") in the specified service context.");
        }
        try {
            return fact.createComponentInstance(configuration);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create the component instance with the given configuration: " + e.getMessage());
        }
    }

    public static ComponentInstance createComponentInstance(ServiceContext serviceContext, String factoryName, String instanceName, Dictionary configuration) {
        configuration.put("instance.name", instanceName);
        return IPOJOHelper.createComponentInstance(serviceContext, factoryName, configuration);
    }

    public ComponentInstance createComponentInstance(String factoryName, String instanceName) {
        ComponentInstance ci = IPOJOHelper.createComponentInstance(this.m_context.getBundle(), factoryName, instanceName);
        this.m_instances.add(ci);
        return ci;
    }

    public ComponentInstance createComponentInstance(String factoryName, Dictionary configuration) {
        ComponentInstance ci = IPOJOHelper.createComponentInstance(this.m_context.getBundle(), factoryName, configuration);
        this.m_instances.add(ci);
        return ci;
    }

    public ComponentInstance createComponentInstance(String factoryName) {
        ComponentInstance ci = IPOJOHelper.createComponentInstance(this.m_context.getBundle(), factoryName, (Dictionary)null);
        this.m_instances.add(ci);
        return ci;
    }

    public ComponentInstance createComponentInstance(String factoryName, String instanceName, Dictionary configuration) {
        ComponentInstance ci = IPOJOHelper.createComponentInstance(this.m_context.getBundle(), factoryName, instanceName, configuration);
        this.m_instances.add(ci);
        return ci;
    }

    public Factory getFactory(String factoryName) {
        return IPOJOHelper.getFactory(this.m_context.getBundle(), factoryName);
    }

    public HandlerFactory getHandlerFactory(String factoryName) {
        return IPOJOHelper.getHandlerFactory(this.m_context.getBundle(), factoryName);
    }

    public Element getMetadata(String component) {
        return IPOJOHelper.getMetadata(this.m_context.getBundle(), component);
    }

    public static Factory getFactory(Bundle bundle, String factoryName) {
        try {
            ServiceReference[] refs = bundle.getBundleContext().getServiceReferences(Factory.class.getName(), "(factory.name=" + factoryName + ")");
            if (refs != null) {
                return (Factory)bundle.getBundleContext().getService(refs[0]);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Cannot get the component factory services: " + e.getMessage());
        }
    }

    public static Factory getFactory(ServiceContext serviceContext, String factoryName) {
        try {
            ServiceReference[] refs = serviceContext.getServiceReferences(Factory.class.getName(), "(factory.name=" + factoryName + ")");
            if (refs != null) {
                return (Factory)serviceContext.getService(refs[0]);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            System.err.println("Cannot get the factory " + factoryName + " : " + e.getMessage());
            return null;
        }
    }

    public static HandlerFactory getHandlerFactory(Bundle bundle, String factoryName) {
        try {
            ServiceReference[] refs = bundle.getBundleContext().getServiceReferences(HandlerFactory.class.getName(), "(handler.name=" + factoryName + ")");
            if (refs != null) {
                return (HandlerFactory)bundle.getBundleContext().getService(refs[0]);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Cannot get the handler factory services: " + e.getMessage());
        }
    }

    public static Element getMetadata(Bundle bundle, String component) {
        String elem = (String)bundle.getHeaders().get("iPOJO-Components");
        if (elem == null) {
            throw new IllegalArgumentException("Cannot find iPOJO-Components descriptor in the specified bundle (" + bundle.getSymbolicName() + "). Not an iPOJO bundle.");
        }
        try {
            Element element = ManifestMetadataParser.parseHeaderMetadata((String)elem);
            Element[] childs = element.getElements("component");
            for (int i = 0; i < childs.length; ++i) {
                String name = childs[i].getAttribute("name");
                String clazz = childs[i].getAttribute("classname");
                if (name != null && name.equalsIgnoreCase(component)) {
                    return childs[i];
                }
                if (!clazz.equalsIgnoreCase(component)) continue;
                return childs[i];
            }
            return null;
        }
        catch (ParseException e) {
            throw new IllegalStateException("Cannot parse the components from specified bundle (" + bundle.getSymbolicName() + "): " + e.getMessage());
        }
    }

    public static Object getServiceObject(ServiceContext serviceContext, String itf, String filter) {
        ServiceReference ref = IPOJOHelper.getServiceReference(serviceContext, itf, filter);
        if (ref != null) {
            return serviceContext.getService(ref);
        }
        return null;
    }

    public static Object[] getServiceObjects(ServiceContext serviceContext, String itf, String filter) {
        ServiceReference[] refs = IPOJOHelper.getServiceReferences(serviceContext, itf, filter);
        if (refs != null) {
            Object[] list = new Object[refs.length];
            for (int i = 0; i < refs.length; ++i) {
                list[i] = serviceContext.getService(refs[i]);
            }
            return list;
        }
        return new Object[0];
    }

    public static ServiceReference getServiceReference(ServiceContext serviceContext, String itf, String filter) {
        ServiceReference[] refs = IPOJOHelper.getServiceReferences(serviceContext, itf, filter);
        if (refs.length != 0) {
            return refs[0];
        }
        return null;
    }

    public static ServiceReference getServiceReferenceByPID(ServiceContext serviceContext, String itf, String pid) {
        String filter = "(service.pid=" + pid + ")";
        ServiceReference[] refs = IPOJOHelper.getServiceReferences(serviceContext, itf, filter);
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        throw new IllegalStateException("A service lookup by PID returned several providers (" + refs.length + ")" + " for " + itf + " with pid=" + pid);
    }

    public static ServiceReference[] getServiceReferences(ServiceContext serviceContext, String itf, String filter) {
        ServiceReference[] refs = null;
        try {
            refs = serviceContext.getServiceReferences(itf, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Cannot get service references: " + e.getMessage());
        }
        if (refs == null) {
            return new ServiceReference[0];
        }
        return refs;
    }

    public static ServiceReference getServiceReferenceByName(ServiceContext serviceContext, String itf, String name) {
        String filter = null;
        filter = itf.equals(Factory.class.getName()) || itf.equals(ManagedServiceFactory.class.getName()) ? "(factory.name=" + name + ")" : (itf.equals(Architecture.class.getName()) ? "(architecture.instance=" + name + ")" : "(instance.name=" + name + ")");
        return IPOJOHelper.getServiceReference(serviceContext, itf, filter);
    }

    public static boolean isServiceAvailable(ServiceContext sc, String itf) {
        ServiceReference ref = IPOJOHelper.getServiceReference(sc, itf, null);
        return ref != null;
    }

    public static boolean isServiceAvailableByName(ServiceContext sc, String itf, String name) {
        ServiceReference ref = IPOJOHelper.getServiceReferenceByName(sc, itf, name);
        return ref != null;
    }

    public static boolean isServiceAvailableByPID(ServiceContext sc, String itf, String pid) {
        ServiceReference ref = IPOJOHelper.getServiceReferenceByPID(sc, itf, pid);
        return ref != null;
    }

    public static ServiceReference getServiceReferenceByName(Bundle bundle, String itf, String name) {
        String filter = null;
        filter = itf.equals(Factory.class.getName()) || itf.equals(ManagedServiceFactory.class.getName()) ? "(factory.name=" + name + ")" : (itf.equals(Architecture.class.getName()) ? "(architecture.instance=" + name + ")" : "(instance.name=" + name + ")");
        return OSGiTestCase.getServiceReference(bundle, itf, filter);
    }

    public ServiceReference getServiceReferenceByName(String itf, String name) {
        return IPOJOHelper.getServiceReferenceByName(this.m_context.getBundle(), itf, name);
    }

    public boolean isServiceAvailableByName(String itf, String name) {
        ServiceReference ref = this.getServiceReferenceByName(itf, name);
        return ref != null;
    }
}

