/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api.composite;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class ProvidedService
implements HandlerConfiguration {
    public static final String ALL_POLICY = "all";
    public static final String ONE_POLICY = "one";
    private String m_specification;
    private List m_delegation = new ArrayList();

    public Element getElement() {
        this.ensureValidity();
        Element dep = new Element("provides", "");
        dep.addAttribute(new Attribute("action", "implement"));
        dep.addAttribute(new Attribute("specification", this.m_specification));
        for (int i = 0; i < this.m_delegation.size(); ++i) {
            dep.addElement((Element)this.m_delegation.get(i));
        }
        return dep;
    }

    public ProvidedService setSpecification(String spec) {
        this.m_specification = spec;
        return this;
    }

    public ProvidedService setDelegation(String method, String policy) {
        Element element = new Element("delegation", "");
        element.addAttribute(new Attribute("method", method));
        element.addAttribute(new Attribute("policy", policy));
        this.m_delegation.add(element);
        return this;
    }

    private void ensureValidity() {
        if (this.m_specification == null) {
            throw new IllegalStateException("The specification of the implemented service must be set");
        }
    }
}

