/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.samples.cometd;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;

public class TimeServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private BayeuxServer bayeuxServer;
    private LocalSession session;
    private List<ServerChannel> channels;
    private Timer updateTimer;
    private SimpleDateFormat logDateFormat;
    private String html = "<html>\n  <head>\n    <title>System Information</title>\n    <script type='text/javascript' src='/js/dojo/dojo.js'></script>\n    <script type='text/javascript'>\n      dojo.require('dojox.cometd');\ndojo.addOnLoad(function()\n{\n    var cometd = dojox.cometd;\n\n    function _connectionEstablished()\n    {\n        dojo.byId('body').innerHTML += '<div>CometD Connection Established</div>';\n    }\n\n    function _connectionBroken()\n    {\n        dojo.byId('body').innerHTML += '<div>CometD Connection Broken</div>';\n    }\n\n    function _connectionClosed()\n    {\n        dojo.byId('body').innerHTML += '<div>CometD Connection Closed</div>';\n    }\n\n    // Function that manages the connection status with the Bayeux server\n    var _connected = false;\n    function _metaConnect(message)\n    {\n        if (cometd.isDisconnected())\n        {\n            _connected = false;\n            _connectionClosed();\n            return;\n        }\n\n        var wasConnected = _connected;\n        _connected = message.successful === true;\n        if (!wasConnected && _connected)\n        {\n            _connectionEstablished();\n        }\n        else if (wasConnected && !_connected)\n        {\n            _connectionBroken();\n        }\n    }\n\n    // Function invoked when first contacting the server and\n    // when the server has lost the state of this client\n    function _metaHandshake(handshake)\n    {\n        if (handshake.successful === true)\n        {\n            cometd.batch(function()\n            {\n                cometd.subscribe('/System/Time', function(message)\n                {\n                    dojo.byId('systemTime').innerHTML = '<div>' + message.data + '</div>';\n                });\n            });\n        }\n    }\n\n    // Disconnect when the page unloads\n    dojo.addOnUnload(function()\n    {\n        cometd.disconnect(true);\n    });\n\n    var cometURL = \"http://localhost:8080/system/cometd\";\n    cometd.configure({\n        url: cometURL,\n        logLevel: 'debug'\n    });\n\n    cometd.addListener('/meta/handshake', _metaHandshake);\n    cometd.addListener('/meta/connect', _metaConnect);\n\n    cometd.handshake();\n});\n    </script>\n  </head>\n  <body>\n    <h2 id='systemTime'></h2>\n  </body>\n</html>\n";

    public TimeServlet(BayeuxServer bayeuxServer) {
        this.bayeuxServer = bayeuxServer;
        this.channels = new ArrayList<ServerChannel>();
        for (SystemTopics topic : SystemTopics.values()) {
            boolean created = bayeuxServer.createIfAbsent("/System/" + (Object)((Object)topic), new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

                public void configureChannel(ConfigurableServerChannel channel) {
                    channel.setPersistent(true);
                }
            }});
            if (!created) continue;
            this.channels.add(topic.ordinal(), this.bayeuxServer.getChannel("/System/" + (Object)((Object)topic)));
        }
        this.logDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.updateTimer = new Timer("System.Time.ClientNotifier");
        this.updateTimer.scheduleAtFixedRate((TimerTask)new ClientNotifier(), 1000L, 1000L);
        this.session = bayeuxServer.newLocalSession(TimeServlet.class.getName());
        this.session.handshake();
    }

    public void init(ServletConfig config) throws ServletException {
        this.doLog("Init with config [" + config + "]");
        super.init(config);
    }

    public void destroy() {
        this.doLog("Destroyed servlet");
        this.updateTimer.cancel();
        this.session.disconnect();
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.println(this.html);
    }

    private void doLog(String message) {
        System.out.println("## TimeServlet: " + message);
    }

    private class ClientNotifier
    extends TimerTask {
        private ClientNotifier() {
        }

        public void run() {
            for (SystemTopics topic : SystemTopics.values()) {
                String topicData;
                switch (topic) {
                    case Time: {
                        topicData = TimeServlet.this.logDateFormat.format(new Date());
                        break;
                    }
                    default: {
                        topicData = "unknown topic: " + topic.toString();
                    }
                }
                ServerMessage.Mutable message = TimeServlet.this.bayeuxServer.newMessage();
                message.setChannel(((ServerChannel)TimeServlet.this.channels.get(topic.ordinal())).getId());
                message.setData((Object)topicData);
                ((ServerChannel)TimeServlet.this.channels.get(topic.ordinal())).publish((Session)TimeServlet.this.session, (Object)topicData, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SystemTopics {
        Time;

    }
}

