/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.regex.Pattern;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.DataModelHelperImpl;
import org.apache.felix.bundlerepository.impl.PullParser;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.felix.obrplugin.Config;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;

public class ObrUpdate {
    private static Pattern TIMESTAMP = Pattern.compile("-[0-9]{8}\\.[0-9]{6}-[0-9]+");
    private static Method setURI;
    private Log m_logger;
    private URI m_repositoryXml;
    private URI m_obrXml;
    private MavenProject m_project;
    private Config m_userConfig;
    private RepositoryImpl m_repository;
    private ResourceImpl m_resourceBundle;
    private URI m_baseURI;

    public ObrUpdate(URI repositoryXml, URI obrXml, MavenProject project, String mavenRepositoryPath, Config userConfig, Log logger) {
        this.m_repositoryXml = repositoryXml;
        this.m_obrXml = obrXml;
        this.m_project = project;
        this.m_logger = logger;
        this.m_userConfig = userConfig;
        this.m_baseURI = userConfig.isRemoteFile() ? ObrUtils.toFileURI(mavenRepositoryPath) : this.m_repositoryXml;
    }

    public void updateRepository(URI bundleJar, URI sourceJar, URI docJar) throws MojoExecutionException {
        URI resourceURI;
        File bundleFile;
        block11: {
            this.m_logger.debug((CharSequence)(" (f) repositoryXml = " + this.m_repositoryXml));
            this.m_logger.debug((CharSequence)(" (f) bundleJar = " + bundleJar));
            this.m_logger.debug((CharSequence)(" (f) sourceJar = " + sourceJar));
            this.m_logger.debug((CharSequence)(" (f) docJar = " + docJar));
            this.m_logger.debug((CharSequence)(" (f) obrXml = " + this.m_obrXml));
            if (this.m_repository == null) {
                return;
            }
            bundleFile = new File(bundleJar);
            if (!bundleFile.exists()) {
                String snapshot = TIMESTAMP.matcher(bundleFile.getName()).replaceFirst("-SNAPSHOT");
                bundleFile = new File(bundleFile.getParentFile(), snapshot);
            }
            if (bundleFile.exists()) {
                resourceURI = this.m_userConfig.getRemoteBundle();
                if (null == resourceURI) {
                    resourceURI = bundleJar;
                    if (this.m_userConfig.isPathRelative()) {
                        resourceURI = ObrUtils.getRelativeURI(this.m_baseURI, resourceURI);
                    }
                }
                if (this.m_userConfig.isRemoteFile()) {
                    this.m_logger.info((CharSequence)("Deploying " + resourceURI));
                } else {
                    this.m_logger.info((CharSequence)("Installing " + resourceURI));
                }
                try {
                    this.m_resourceBundle = (ResourceImpl)new DataModelHelperImpl().createResource(bundleFile.toURI().toURL());
                    if (this.m_resourceBundle == null) {
                        return;
                    }
                    break block11;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to load resource information", (Exception)e);
                }
            }
            this.m_logger.error((CharSequence)("file doesn't exist: " + bundleJar));
            return;
        }
        this.m_resourceBundle.put((Object)"size", (Object)String.valueOf(bundleFile.length()));
        this.m_resourceBundle.put((Object)"uri", (Object)resourceURI.toASCIIString());
        if (this.m_obrXml != null) {
            this.m_logger.info((CharSequence)("Adding " + this.m_obrXml));
            this.parseObrXml();
        }
        String sourcePath = this.relativisePath(sourceJar);
        String docPath = this.relativisePath(docJar);
        this.m_repository.addResource((Resource)this.m_resourceBundle);
        this.m_repository.setLastModified(System.currentTimeMillis());
    }

    private String relativisePath(URI uri) {
        if (null != uri) {
            if (this.m_userConfig.isPathRelative()) {
                return ObrUtils.getRelativeURI(this.m_baseURI, uri).toASCIIString();
            }
            return uri.toASCIIString();
        }
        return null;
    }

    public void writeRepositoryXml() throws MojoExecutionException {
        OutputStreamWriter writer;
        this.m_logger.info((CharSequence)"Writing OBR metadata");
        File file = null;
        try {
            file = File.createTempFile("repository", ".xml");
            writer = new OutputStreamWriter(new FileOutputStream(file));
        }
        catch (IOException e) {
            this.m_logger.error((CharSequence)("Unable to write to file: " + file.getName()));
            e.printStackTrace();
            throw new MojoExecutionException("Unable to write to file: " + file.getName() + " : " + e.getMessage());
        }
        try {
            new DataModelHelperImpl().writeRepository((Repository)this.m_repository, (Writer)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write repository xml", (Exception)e);
        }
        try {
            ((Writer)writer).flush();
            ((Writer)writer).close();
            File outputFile = new File(this.m_repositoryXml);
            outputFile.getParentFile().mkdirs();
            FileUtils.rename((File)file, (File)outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("IOException");
        }
    }

    public void parseRepositoryXml() throws MojoExecutionException {
        File fout = new File(this.m_repositoryXml);
        if (!fout.exists()) {
            this.m_repository = new RepositoryImpl();
            this.writeRepositoryXml();
        } else {
            try {
                this.m_repository = (RepositoryImpl)new DataModelHelperImpl().repository(this.m_repositoryXml.toURL());
                if (setURI != null) {
                    setURI.invoke((Object)this.m_repository, new Object[]{null});
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to read repository xml: " + this.m_repositoryXml, e);
            }
        }
    }

    private void parseObrXml() throws MojoExecutionException {
        try (FileInputStream is = new FileInputStream(new File(this.m_obrXml));){
            KXmlParser kxp = new KXmlParser();
            kxp.setInput((InputStream)is, null);
            kxp.nextTag();
            kxp.nextTag();
            this.parseObrXml(kxp);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to parse obr xml: " + this.m_obrXml, e);
        }
    }

    private void parseObrXml(KXmlParser kxp) throws Exception {
        PullParser parser = new PullParser();
        while (kxp.getEventType() == 2) {
            if ("category".equals(kxp.getName())) {
                this.m_resourceBundle.addCategory(parser.parseCategory((XmlPullParser)kxp));
            } else if ("require".equals(kxp.getName())) {
                this.m_resourceBundle.addRequire((Requirement)parser.parseRequire((XmlPullParser)kxp));
            } else if ("capability".equals(kxp.getName())) {
                this.m_resourceBundle.addCapability((Capability)parser.parseCapability((XmlPullParser)kxp));
            } else {
                kxp.nextTag();
                this.parseObrXml(kxp);
            }
            kxp.nextTag();
        }
    }

    static {
        try {
            setURI = RepositoryImpl.class.getDeclaredMethod("setURI", String.class);
            setURI.setAccessible(true);
        }
        catch (Exception e) {
            setURI = null;
        }
    }
}

