/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.api;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.ILdapLogger;
import org.apache.directory.studio.connection.core.ReferralsInfo;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.io.StudioLdapException;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResult;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifLineBase;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class LdifSearchLogger
implements ILdapLogger {
    private String id;
    private String name;
    private String description;
    private Map<String, FileHandler> fileHandlers = new HashMap<String, FileHandler>();
    private Map<String, Logger> loggers = new HashMap<String, Logger>();

    public LdifSearchLogger() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ConnectionCoreConstants.PLUGIN_ID);
        prefs.addPreferenceChangeListener(event -> {
            if ("searchLogsFileCount".equals(event.getKey()) || "searchLogsFileSize".equals(event.getKey())) {
                Connection[] connections;
                int n;
                for (Logger logger : this.loggers.values()) {
                    Handler[] handlerArray = logger.getHandlers();
                    int n2 = handlerArray.length;
                    n = 0;
                    while (n < n2) {
                        Handler handler = handlerArray[n];
                        handler.close();
                        ++n;
                    }
                }
                Connection[] connectionArray = connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
                n = connections.length;
                int n3 = 0;
                while (n3 < n) {
                    Connection connection = connectionArray[n3];
                    try {
                        File[] logFiles = LdifSearchLogger.getLogFiles(connection);
                        int i = this.getFileCount();
                        while (i < logFiles.length) {
                            if (logFiles[i] != null && logFiles[i].exists()) {
                                logFiles[i].delete();
                            }
                            ++i;
                        }
                    }
                    catch (Exception exception) {}
                    ++n3;
                }
                this.loggers.clear();
            }
        });
    }

    private void initSearchLogger(Connection connection) {
        Logger logger = Logger.getAnonymousLogger();
        this.loggers.put(connection.getId(), logger);
        logger.setLevel(Level.ALL);
        String logfileName = ConnectionManager.getSearchLogFileName(connection);
        try {
            FileHandler fileHandler = new FileHandler(logfileName, this.getFileSizeInKb() * 1000, this.getFileCount(), true);
            this.fileHandlers.put(connection.getId(), fileHandler);
            fileHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage();
                }
            });
            logger.addHandler(fileHandler);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dispose(Connection connection) {
        String id = connection.getId();
        if (this.loggers.containsKey(id)) {
            File[] files;
            Handler[] handlers;
            Handler[] handlerArray = handlers = this.loggers.get(id).getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                handler.close();
                ++n2;
            }
            File[] fileArray = files = LdifSearchLogger.getLogFiles(connection);
            int n3 = files.length;
            n = 0;
            while (n < n3) {
                File file = fileArray[n];
                this.deleteFileWithRetry(file);
                ++n;
            }
            this.loggers.remove(id);
        }
    }

    private void log(String text, String type, StudioLdapException ex, Connection connection) {
        String id = connection.getId();
        if (!this.loggers.containsKey(id) && connection.getName() != null) {
            this.initSearchLogger(connection);
        }
        if (this.loggers.containsKey(id)) {
            StringJoiner lines = new StringJoiner("");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            df.setTimeZone(ConnectionCoreConstants.UTC_TIME_ZONE);
            if (ex != null) {
                lines.add(LdifCommentLine.create((String)("#!" + type + " ERROR")).toFormattedString(LdifFormatParameters.DEFAULT));
            } else {
                lines.add(LdifCommentLine.create((String)("#!" + type + " OK")).toFormattedString(LdifFormatParameters.DEFAULT));
            }
            lines.add(LdifCommentLine.create((String)("#!CONNECTION ldap://" + connection.getHost() + ":" + connection.getPort())).toFormattedString(LdifFormatParameters.DEFAULT));
            lines.add(LdifCommentLine.create((String)("#!DATE " + df.format(new Date()))).toFormattedString(LdifFormatParameters.DEFAULT));
            if (ex != null) {
                String errorComment = "#!ERROR " + ex.getMessage();
                errorComment = errorComment.replaceAll("\r", " ");
                errorComment = errorComment.replaceAll("\n", " ");
                LdifCommentLine errorCommentLine = LdifCommentLine.create((String)errorComment);
                lines.add(errorCommentLine.toFormattedString(LdifFormatParameters.DEFAULT));
            }
            lines.add(text);
            Logger logger = this.loggers.get(id);
            logger.log(Level.ALL, lines.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logSearchRequest(Connection connection, String searchBase, String filter, SearchControls searchControls, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Control[] controls, long requestNum, StudioLdapException ex) {
        String attributesAsString;
        String scopeAsString;
        if (!this.isSearchRequestLogEnabled()) {
            return;
        }
        String string = searchControls.getSearchScope() == 2 ? "wholeSubtree (2)" : (scopeAsString = searchControls.getSearchScope() == 1 ? "singleLevel (1)" : "baseObject (0)");
        String string2 = searchControls.getReturningAttributes() == null ? "*" : (attributesAsString = searchControls.getReturningAttributes().length == 0 ? "1.1" : StringUtils.join((Object[])searchControls.getReturningAttributes(), (String)" "));
        String aliasAsString = aliasesDereferencingMethod == Connection.AliasDereferencingMethod.ALWAYS ? "derefAlways (3)" : (aliasesDereferencingMethod == Connection.AliasDereferencingMethod.FINDING ? "derefFindingBaseObj (2)" : (aliasesDereferencingMethod == Connection.AliasDereferencingMethod.SEARCH ? "derefInSearching (1)" : "neverDerefAliases (0)"));
        LdapUrl url = Utils.getLdapURL(connection, searchBase, searchControls.getSearchScope(), filter, searchControls.getReturningAttributes());
        String cmdLine = Utils.getLdapSearchCommandLine(connection, searchBase, searchControls.getSearchScope(), aliasesDereferencingMethod, searchControls.getCountLimit(), searchControls.getTimeLimit(), filter, searchControls.getReturningAttributes());
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(LdifCommentLine.create((String)("# LDAP URL     : " + url.toString())));
        lines.add(LdifCommentLine.create((String)("# command line : " + cmdLine.toString())));
        lines.add(LdifCommentLine.create((String)("# baseObject   : " + searchBase)));
        lines.add(LdifCommentLine.create((String)("# scope        : " + scopeAsString)));
        lines.add(LdifCommentLine.create((String)("# derefAliases : " + aliasAsString)));
        lines.add(LdifCommentLine.create((String)("# sizeLimit    : " + searchControls.getCountLimit())));
        lines.add(LdifCommentLine.create((String)("# timeLimit    : " + searchControls.getTimeLimit())));
        lines.add(LdifCommentLine.create((String)"# typesOnly    : False"));
        lines.add(LdifCommentLine.create((String)("# filter       : " + filter)));
        lines.add(LdifCommentLine.create((String)("# attributes   : " + attributesAsString)));
        if (controls != null) {
            void var17_19;
            Control[] controlArray = controls;
            int n = controls.length;
            boolean n2 = false;
            while (var17_19 < n) {
                Control control = controlArray[var17_19];
                lines.add(LdifCommentLine.create((String)("# control      : " + control.getOid())));
                ++var17_19;
            }
        }
        lines.add(LdifSepLine.create());
        String formattedString = "";
        for (LdifLineBase ldifLineBase : lines) {
            formattedString = String.valueOf(formattedString) + ldifLineBase.toFormattedString(LdifFormatParameters.DEFAULT);
        }
        this.log(formattedString, "SEARCH REQUEST (" + requestNum + ")", ex, connection);
    }

    @Override
    public void logSearchResultEntry(Connection connection, StudioSearchResult studioSearchResult, long requestNum, StudioLdapException ex) {
        String formattedString;
        if (!this.isSearchResultEntryLogEnabled()) {
            return;
        }
        if (studioSearchResult != null) {
            Set<String> maskedAttributes = this.getMaskedAttributes();
            Entry entry = studioSearchResult.getEntry();
            LdifContentRecord record = new LdifContentRecord(LdifDnLine.create((String)entry.getDn().getName()));
            for (Attribute attribute : entry) {
                String attributeName = attribute.getUpId();
                for (Value value : attribute) {
                    if (maskedAttributes.contains(Strings.toLowerCaseAscii((String)attributeName))) {
                        record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)"**********"));
                        continue;
                    }
                    if (value.isHumanReadable()) {
                        record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)value.getString()));
                        continue;
                    }
                    record.addAttrVal(LdifAttrValLine.create((String)attributeName, (byte[])value.getBytes()));
                }
            }
            record.finish(LdifSepLine.create());
            formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
        } else {
            formattedString = LdifFormatParameters.DEFAULT.getLineSeparator();
        }
        this.log(formattedString, "SEARCH RESULT ENTRY (" + requestNum + ")", ex, connection);
    }

    @Override
    public void logSearchResultReference(Connection connection, Referral referral, ReferralsInfo referralsInfo, long requestNum, StudioLdapException ex) {
        if (!this.isSearchResultEntryLogEnabled()) {
            return;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(LdifCommentLine.create((String)("# reference : " + (referral != null ? referral.getLdapUrls() : "null"))));
        lines.add(LdifSepLine.create());
        String formattedString = "";
        for (LdifLineBase ldifLineBase : lines) {
            formattedString = String.valueOf(formattedString) + ldifLineBase.toFormattedString(LdifFormatParameters.DEFAULT);
        }
        this.log(formattedString, "SEARCH RESULT REFERENCE (" + requestNum + ")", ex, connection);
    }

    @Override
    public void logSearchResultDone(Connection connection, long count, long requestNum, StudioLdapException ex) {
        if (!this.isSearchRequestLogEnabled()) {
            return;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(LdifCommentLine.create((String)("# numEntries : " + count)));
        lines.add(LdifSepLine.create());
        String formattedString = "";
        for (LdifLineBase ldifLineBase : lines) {
            formattedString = String.valueOf(formattedString) + ldifLineBase.toFormattedString(LdifFormatParameters.DEFAULT);
        }
        this.log(formattedString, "SEARCH RESULT DONE (" + requestNum + ")", ex, connection);
    }

    public File[] getFiles(Connection connection) {
        String id = connection.getId();
        if (!this.loggers.containsKey(id) && connection.getName() != null) {
            this.initSearchLogger(connection);
        }
        try {
            return LdifSearchLogger.getLogFiles(connection);
        }
        catch (Exception exception) {
            return new File[0];
        }
    }

    private static File[] getLogFiles(Connection connection) {
        String logfileNamePattern = ConnectionManager.getSearchLogFileName(connection);
        File file = new File(logfileNamePattern);
        String pattern = file.getName().replace("%u", "\\d+").replace("%g", "\\d+");
        File dir = file.getParentFile();
        Object[] files = dir.listFiles((d, f) -> f.matches(pattern));
        Arrays.sort(files);
        return files;
    }

    private boolean isSearchRequestLogEnabled() {
        return ConnectionCorePlugin.getDefault().isSearchRequestLogsEnabled();
    }

    private boolean isSearchResultEntryLogEnabled() {
        return ConnectionCorePlugin.getDefault().isSearchResultEntryLogsEnabled();
    }

    private int getFileCount() {
        return ConnectionCorePlugin.getDefault().getSearchLogsFileCount();
    }

    private int getFileSizeInKb() {
        return ConnectionCorePlugin.getDefault().getSearchLogsFileSize();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}

