/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.ui.widgets.ConnectionActionGroup;
import org.apache.directory.studio.connection.ui.widgets.ConnectionConfiguration;
import org.apache.directory.studio.connection.ui.widgets.ConnectionUniversalListener;
import org.apache.directory.studio.connection.ui.widgets.ConnectionWidget;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewProjectWizardConnectionSelectionPage
extends AbstractWizardPage {
    private ConnectionConfiguration configuration;
    private ConnectionUniversalListener universalListener;
    private ConnectionWidget connectionWidget;
    private ConnectionActionGroup actionGroup;

    protected NewProjectWizardConnectionSelectionPage() {
        super("NewProjectWizardConnectionSelectionPage");
        this.setTitle(Messages.getString("NewProjectWizardConnectionSelectionPage.CreateSchemaProject"));
        this.setDescription(Messages.getString("NewProjectWizardConnectionSelectionPage.PleaseSelectConnection"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/project_new_wizard.png"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("NewProjectWizardConnectionSelectionPage.ChooseConnection"));
        label.setLayoutData((Object)new GridData(4, 0, true, false));
        this.configuration = new ConnectionConfiguration();
        this.connectionWidget = new ConnectionWidget(this.configuration, null);
        this.connectionWidget.createWidget(composite);
        this.connectionWidget.setInput((Object)ConnectionCorePlugin.getDefault().getConnectionFolderManager());
        this.connectionWidget.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewProjectWizardConnectionSelectionPage.this.validatePage();
            }
        });
        this.universalListener = new ConnectionUniversalListener(this.connectionWidget.getViewer());
        this.actionGroup = new ConnectionActionGroup(this.connectionWidget, this.configuration);
        this.actionGroup.fillToolBar(this.connectionWidget.getToolBarManager());
        this.actionGroup.fillMenu(this.connectionWidget.getMenuManager());
        this.actionGroup.fillContextMenu(this.connectionWidget.getContextMenuManager());
        this.actionGroup.activateGlobalActionHandlers();
        this.initFields();
        this.setControl((Control)composite);
    }

    private void initFields() {
        this.displayErrorMessage(null);
        this.setPageComplete(false);
    }

    private void validatePage() {
        ISelection selection = this.connectionWidget.getViewer().getSelection();
        if (selection.isEmpty()) {
            this.displayErrorMessage(Messages.getString("NewProjectWizardConnectionSelectionPage.ErrorNoConnectionSelected"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public Connection getSelectedConnection() {
        return (Connection)((StructuredSelection)this.connectionWidget.getViewer().getSelection()).getFirstElement();
    }

    public void dispose() {
        if (this.configuration != null) {
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.configuration.dispose();
            this.configuration = null;
            this.universalListener.dispose();
            this.universalListener = null;
            this.connectionWidget.dispose();
            this.connectionWidget = null;
        }
        super.dispose();
    }
}

