/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetPreferences;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class EntryEditorWidgetSorterDialog
extends Dialog {
    public static final String DIALOG_TITLE = Messages.getString("EntryEditorWidgetSorterDialog.EntryEditorSorting");
    public static final String SORT_BY_NONE = Messages.getString("EntryEditorWidgetSorterDialog.NoDefaultSorting");
    public static final String SORT_BY_ATTRIBUTE = Messages.getString("EntryEditorWidgetSorterDialog.AttributeDescription");
    public static final String SORT_BY_VALUE = Messages.getString("EntryEditorWidgetSorterDialog.Value");
    private EntryEditorWidgetPreferences preferences;
    private Button objectClassAndMustAttributesFirstButton;
    private Button operationalAttributesLastButton;
    private Combo sortByCombo;
    private Button sortAcendingButton;
    private Button sortDescendingButton;

    public EntryEditorWidgetSorterDialog(Shell parentShell, EntryEditorWidgetPreferences preferences) {
        super(parentShell);
        this.preferences = preferences;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
            store.setValue("entryeditorObjectClassAndMustAttributesFirst", this.objectClassAndMustAttributesFirstButton.getSelection());
            store.setValue("entryeditorOperationalAttributesLast", this.operationalAttributesLastButton.getSelection());
            store.setValue("entryeditorDefaultSortOrder", this.sortDescendingButton.getSelection() ? 2 : 1);
            store.setValue("entryeditorDefaultSortBy", this.sortByCombo.getSelectionIndex() == 2 ? 4 : (this.sortByCombo.getSelectionIndex() == 1 ? 3 : 0));
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Group group = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("EntryEditorWidgetSorterDialog.GroupAttributes"), (int)1);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        group.setLayoutData((Object)gd);
        this.objectClassAndMustAttributesFirstButton = BaseWidgetUtils.createCheckbox((Composite)group, (String)Messages.getString("EntryEditorWidgetSorterDialog.ObjectClassAndMustAttributesFirst"), (int)1);
        this.objectClassAndMustAttributesFirstButton.setSelection(this.preferences.isObjectClassAndMustAttributesFirst());
        this.operationalAttributesLastButton = BaseWidgetUtils.createCheckbox((Composite)group, (String)Messages.getString("EntryEditorWidgetSorterDialog.OperationalAttributesLast"), (int)1);
        this.operationalAttributesLastButton.setSelection(this.preferences.isOperationalAttributesLast());
        Group sortingGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("EntryEditorWidgetSorterDialog.SortAttributes"), (int)1);
        Composite sortByComposite = BaseWidgetUtils.createColumnContainer((Composite)sortingGroup, (int)4, (int)1);
        BaseWidgetUtils.createLabel((Composite)sortByComposite, (String)Messages.getString("EntryEditorWidgetSorterDialog.SortBy"), (int)1);
        this.sortByCombo = BaseWidgetUtils.createReadonlyCombo((Composite)sortByComposite, (String[])new String[]{SORT_BY_NONE, SORT_BY_ATTRIBUTE, SORT_BY_VALUE}, (int)0, (int)1);
        this.sortByCombo.select(this.preferences.getDefaultSortBy() == 4 ? 2 : (this.preferences.getDefaultSortBy() == 3 ? 1 : 0));
        this.sortByCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryEditorWidgetSorterDialog.this.sortAcendingButton.setEnabled(EntryEditorWidgetSorterDialog.this.sortByCombo.getSelectionIndex() != 0);
                EntryEditorWidgetSorterDialog.this.sortDescendingButton.setEnabled(EntryEditorWidgetSorterDialog.this.sortByCombo.getSelectionIndex() != 0);
            }
        });
        this.sortAcendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortByComposite, (String)Messages.getString("EntryEditorWidgetSorterDialog.Ascending"), (int)1);
        this.sortAcendingButton.setSelection(this.preferences.getDefaultSortOrder() == 1);
        this.sortAcendingButton.setEnabled(this.sortByCombo.getSelectionIndex() != 0);
        this.sortDescendingButton = BaseWidgetUtils.createRadiobutton((Composite)sortByComposite, (String)Messages.getString("EntryEditorWidgetSorterDialog.Descending"), (int)1);
        this.sortDescendingButton.setSelection(this.preferences.getDefaultSortOrder() == 2);
        this.sortDescendingButton.setEnabled(this.sortByCombo.getSelectionIndex() != 0);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)2);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("EntryEditorWidgetSorterDialog.SortTableHint"), (int)1);
        EntryEditorWidgetSorterDialog.applyDialogFont((Control)composite);
        return composite;
    }
}

