/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.DeleteAction;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.EntryEditorActionProxy;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.common.wizards.AttributeWizard;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class EditAttributeDescriptionAction
extends BrowserAction {
    private EntryEditorActionProxy deleteActionProxy;

    public EditAttributeDescriptionAction(Viewer viewer) {
        this.deleteActionProxy = new EntryEditorActionProxy(viewer, (BrowserAction)new DeleteAction());
    }

    @Override
    public String getCommandId() {
        return BrowserCommonConstants.ACTION_ID_EDIT_ATTRIBUTE_DESCRIPTION;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getText() {
        return Messages.getString("EditAttributeDescriptionAction.EditAttributeDescription");
    }

    @Override
    public boolean isEnabled() {
        return this.deleteActionProxy.getAction().isEnabled();
    }

    @Override
    public void run() {
        if (this.getSelectedAttributes().length == 1) {
            this.renameValues(this.getSelectedAttributes()[0].getValues());
        } else if (this.getSelectedValues().length > 0) {
            this.renameValues(this.getSelectedValues());
        }
    }

    private void renameValues(IValue[] values) {
        AttributeWizard wizard = new AttributeWizard(Messages.getString("EditAttributeDescriptionAction.EditAttributeDescription"), true, false, values[0].getAttribute().getDescription(), values[0].getAttribute().getEntry());
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(true);
        dialog.create();
        if (dialog.open() == 0) {
            String newAttributeDescription = wizard.getAttributeDescription();
            new CompoundModification().renameValues(values, newAttributeDescription);
        }
    }
}

