/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.studio.connection.ui.actions.CollapseAllAction;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.FilterChildrenAction;
import org.apache.directory.studio.ldapbrowser.common.actions.OpenQuickSearchAction;
import org.apache.directory.studio.ldapbrowser.common.actions.PropertiesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.RefreshAction;
import org.apache.directory.studio.ldapbrowser.common.actions.UnfilterChildrenAction;
import org.apache.directory.studio.ldapbrowser.common.actions.UpAction;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.ActionHandlerManager;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.BrowserViewActionProxy;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.OpenSortDialogAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.ShowQuickSearchAction;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.utils.ActionUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class BrowserActionGroup
implements ActionHandlerManager,
IMenuListener {
    protected OpenSortDialogAction openSortDialogAction;
    protected ShowQuickSearchAction showQuickSearchAction;
    protected CollapseAllAction collapseAllAction;
    protected static final String UP_ACTION = "upAction";
    protected static final String REFRESH_ACTION = "refreshAction";
    protected static final String FILTER_CHILDREN_ACTION = "filterChildrenAction";
    protected static final String OPEN_QUICK_SEARCH_ACTION = "openQuickSearch";
    protected static final String UNFILTER_CHILDREN_ACTION = "unfilterChildrenAction";
    protected static final String PROPERTY_DIALOG_ACTION = "propertyDialogAction";
    protected Map<String, BrowserViewActionProxy> browserActionMap;
    protected IActionBars actionBars;
    protected BrowserWidget mainWidget;

    public BrowserActionGroup(BrowserWidget mainWidget, BrowserConfiguration configuration) {
        this.mainWidget = mainWidget;
        this.browserActionMap = new HashMap<String, BrowserViewActionProxy>();
        TreeViewer viewer = mainWidget.getViewer();
        this.openSortDialogAction = new OpenSortDialogAction(configuration.getPreferences());
        this.showQuickSearchAction = new ShowQuickSearchAction(mainWidget.getQuickSearchWidget());
        this.collapseAllAction = new CollapseAllAction(viewer);
        this.browserActionMap.put(OPEN_QUICK_SEARCH_ACTION, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new OpenQuickSearchAction()));
        this.browserActionMap.put(UP_ACTION, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new UpAction(viewer)));
        this.browserActionMap.put(REFRESH_ACTION, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new RefreshAction()));
        this.browserActionMap.put(FILTER_CHILDREN_ACTION, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new FilterChildrenAction()));
        this.browserActionMap.put(UNFILTER_CHILDREN_ACTION, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new UnfilterChildrenAction()));
        this.browserActionMap.put(PROPERTY_DIALOG_ACTION, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new PropertiesAction()));
    }

    public void dispose() {
        if (this.mainWidget != null) {
            this.openSortDialogAction.dispose();
            this.openSortDialogAction = null;
            this.showQuickSearchAction.dispose();
            this.showQuickSearchAction = null;
            this.collapseAllAction.dispose();
            this.collapseAllAction = null;
            for (BrowserViewActionProxy action : this.browserActionMap.values()) {
                action.dispose();
            }
            this.browserActionMap.clear();
            this.browserActionMap = null;
            this.actionBars = null;
            this.mainWidget = null;
        }
    }

    public void enableGlobalActionHandlers(IActionBars actionBars) {
        this.actionBars = actionBars;
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.browserActionMap.get(UP_ACTION));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.browserActionMap.get(REFRESH_ACTION));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.collapseAllAction);
        toolBarManager.update(true);
    }

    public void fillMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.openSortDialogAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.showQuickSearchAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.update(true);
    }

    public void fillContextMenu(IMenuManager menuManager) {
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.browserActionMap.get(UP_ACTION));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.browserActionMap.get(FILTER_CHILDREN_ACTION));
        if (this.browserActionMap.get(UNFILTER_CHILDREN_ACTION).isEnabled()) {
            menuManager.add((IAction)this.browserActionMap.get(UNFILTER_CHILDREN_ACTION));
        }
        menuManager.add((IAction)this.browserActionMap.get(OPEN_QUICK_SEARCH_ACTION));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.browserActionMap.get(REFRESH_ACTION));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.browserActionMap.get(PROPERTY_DIALOG_ACTION));
    }

    @Override
    public void activateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.browserActionMap.get(REFRESH_ACTION));
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.browserActionMap.get(PROPERTY_DIALOG_ACTION));
            this.actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.showQuickSearchAction);
            this.actionBars.updateActionBars();
        } else {
            IAction pda = (IAction)this.browserActionMap.get(PROPERTY_DIALOG_ACTION);
            pda.setActionDefinitionId(BrowserCommonConstants.CMD_PROPERTIES);
            ActionUtils.activateActionHandler((IAction)pda);
            IAction ra = (IAction)this.browserActionMap.get(REFRESH_ACTION);
            ActionUtils.activateActionHandler((IAction)ra);
            this.showQuickSearchAction.setActionDefinitionId(BrowserCommonConstants.CMD_FIND);
            ActionUtils.activateActionHandler((IAction)this.showQuickSearchAction);
        }
        IAction ua = (IAction)this.browserActionMap.get(UP_ACTION);
        ActionUtils.activateActionHandler((IAction)ua);
    }

    @Override
    public void deactivateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), null);
            this.actionBars.updateActionBars();
        } else {
            IAction ra = (IAction)this.browserActionMap.get(REFRESH_ACTION);
            ActionUtils.deactivateActionHandler((IAction)ra);
            IAction pda = (IAction)this.browserActionMap.get(PROPERTY_DIALOG_ACTION);
            ActionUtils.deactivateActionHandler((IAction)pda);
        }
        IAction ua = (IAction)this.browserActionMap.get(UP_ACTION);
        ActionUtils.deactivateActionHandler((IAction)ua);
    }

    public void setInput(IBrowserConnection connection) {
        for (BrowserViewActionProxy action : this.browserActionMap.values()) {
            action.inputChanged(connection);
        }
    }
}

