/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;

public class CheatSheetHyperlinkActionFactory {
    private static final String CHEAT_SHEET_PROTOCOL = "http";
    private static final String CHEAT_SHEET_HOST_ID = "org.eclipse.ui.cheatsheet";
    private static final String EXECUTE = "execute";
    private static final String SHOW_VIEW = "showView";
    private static final String KEY_ID = "id";
    private static final String KEY_COMAND = "command";
    private static final String KEY_DECODE = "decode";
    private static final String VALUE_TRUE = "true";

    public CheatSheetHyperlinkAction create(String urlString) {
        if (urlString == null) {
            return new FallbackAction(urlString);
        }
        try {
            URL url;
            block14: {
                url = new URL(urlString);
                if (!this.isCheatSheetHyperlink(url)) break block14;
                String action = this.getPathAsAction(url);
                Properties parameters = this.getQueryParameters(url);
                switch (action) {
                    case "execute": {
                        return new CommandAction(this.getParameter(parameters, KEY_COMAND));
                    }
                    case "showView": {
                        return new ShowViewAction(this.getParameter(parameters, KEY_ID));
                    }
                }
                CheatSheetPlugin.getPlugin().getLog().error("Unsupported action: " + action, null);
                return new FallbackAction(urlString);
            }
            if (url.getProtocol() != null) {
                return new OpenInBrowserAction(url);
            }
            return new FallbackAction(urlString);
        }
        catch (MalformedURLException e) {
            CheatSheetPlugin.getPlugin().getLog().error("Malformed URL: " + urlString, (Throwable)e);
            return new FallbackAction(urlString);
        }
    }

    private boolean isCheatSheetHyperlink(URL url) {
        if (!url.getProtocol().equalsIgnoreCase(CHEAT_SHEET_PROTOCOL)) {
            return false;
        }
        return url.getHost().equalsIgnoreCase(CHEAT_SHEET_HOST_ID);
    }

    private Properties getQueryParameters(URL url) {
        Properties properties = new Properties();
        String query = url.getQuery();
        if (query == null) {
            return properties;
        }
        String[] params = query.split("&");
        int i = 0;
        while (i < params.length) {
            String[] keyValuePair = params[i].split("=");
            if (keyValuePair.length != 2) {
                CheatSheetPlugin.getPlugin().getLog().warn(MessageFormat.format("Ignoring the following Cheatsheet URL parameter: {0}", params[i]));
            } else {
                String key = this.urlDecode(keyValuePair[0]);
                if (key == null) {
                    CheatSheetPlugin.getPlugin().getLog().warn(MessageFormat.format("Failed to URL decode key: {0}", keyValuePair[0]));
                } else {
                    String value = this.urlDecode(keyValuePair[1]);
                    if (value == null) {
                        CheatSheetPlugin.getPlugin().getLog().warn(MessageFormat.format("Failed to URL decode value: {0}", keyValuePair[1]));
                    } else {
                        properties.setProperty(key, value);
                    }
                }
            }
            ++i;
        }
        return properties;
    }

    private String urlDecode(String encodedURL) {
        int len = encodedURL.length();
        ByteArrayOutputStream os = new ByteArrayOutputStream(len);
        int i = 0;
        while (i < len) {
            switch (encodedURL.charAt(i)) {
                case '%': {
                    if (len >= i + 3) {
                        os.write(Integer.parseInt(encodedURL.substring(i + 1, i + 3), 16));
                    }
                    i += 3;
                    break;
                }
                case '+': {
                    os.write(32);
                    ++i;
                    break;
                }
                default: {
                    os.write(encodedURL.charAt(i++));
                }
            }
        }
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    private String getPathAsAction(URL url) {
        String action = url.getPath();
        if (action != null) {
            action = action.substring(1);
        }
        return action;
    }

    private String getParameter(Properties parameters, String parameterId) {
        String value = parameters.getProperty(parameterId);
        String decode = parameters.getProperty(KEY_DECODE);
        if (value != null) {
            try {
                if (decode != null && decode.equalsIgnoreCase(VALUE_TRUE)) {
                    return URLDecoder.decode(value, StandardCharsets.UTF_8);
                }
                return value;
            }
            catch (Exception e) {
                CheatSheetPlugin.getPlugin().getLog().error("Failed to decode URL: " + parameterId, (Throwable)e);
            }
        }
        return value;
    }

    public static abstract class CheatSheetHyperlinkAction {
        public final void execute() {
            Display display = Display.getDefault();
            BusyIndicator.showWhile((Display)display, () -> this.doExecute(display));
        }

        protected abstract void doExecute(Display var1);
    }

    private static class CommandAction
    extends CheatSheetHyperlinkAction {
        private final String command;

        public CommandAction(String command) {
            this.command = command;
        }

        @Override
        protected void doExecute(Display display) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            if (commandService == null || handlerService == null) {
                CheatSheetPlugin.getPlugin().getLog().error("Could not get ICommandService or IHandlerService while trying to execute: " + this.command, null);
                return;
            }
            try {
                ParameterizedCommand pCommand = commandService.deserialize(this.command);
                handlerService.executeCommand(pCommand, null);
            }
            catch (CommandException e) {
                CheatSheetPlugin.getPlugin().getLog().error("Could not execute command: " + this.command, (Throwable)e);
            }
        }
    }

    private static class FallbackAction
    extends CheatSheetHyperlinkAction {
        private final String url;

        public FallbackAction(String url) {
            this.url = url;
        }

        @Override
        public void doExecute(Display display) {
            MessageDialog.openInformation((Shell)display.getActiveShell(), null, (String)MessageFormat.format(Messages.CHEAT_SHEET_UNSUPPORTED_LINK_ACTIVATION_MESSAGE, this.url));
        }
    }

    private static class OpenInBrowserAction
    extends CheatSheetHyperlinkAction {
        private final URL url;

        public OpenInBrowserAction(URL url) {
            this.url = url;
        }

        @Override
        public void doExecute(Display display) {
            try {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                support.getExternalBrowser().openURL(this.url);
            }
            catch (PartInitException e) {
                CheatSheetPlugin.getPlugin().getLog().error("Cheatsheet failed to get Browser support.", (Throwable)e);
            }
        }
    }

    private static class ShowViewAction
    extends CheatSheetHyperlinkAction {
        private final String viewId;

        public ShowViewAction(String viewId) {
            this.viewId = viewId;
        }

        @Override
        protected void doExecute(Display display) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null) {
                try {
                    activeWorkbenchWindow.getActivePage().showView(this.viewId, null, 1);
                }
                catch (PartInitException e) {
                    CheatSheetPlugin.getPlugin().getLog().error("Error while activating view: " + this.viewId, (Throwable)e);
                }
            }
        }
    }
}

