/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MatchingRuleUseDescriptionDetailsPage
extends SchemaDetailsPage {
    private Section mainSection;
    private Text numericOidText;
    private Hyperlink nameLink;
    private Text descText;
    private Section flagSection;
    private Label isObsoleteText;
    private Section appliesSection;

    public MatchingRuleUseDescriptionDetailsPage(SchemaPage schemaPage, FormToolkit toolkit) {
        super(schemaPage, toolkit);
    }

    @Override
    public void createContents(final ScrolledForm detailForm) {
        this.detailForm = detailForm;
        detailForm.getBody().setLayout((Layout)new GridLayout());
        this.mainSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.mainSection.setText(Messages.getString("MatchingRuleUseDescriptionDetailsPage.Details"));
        this.mainSection.marginWidth = 0;
        this.mainSection.marginHeight = 0;
        this.mainSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.mainSection);
        this.flagSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.flagSection.setText(Messages.getString("MatchingRuleUseDescriptionDetailsPage.Flags"));
        this.flagSection.marginWidth = 0;
        this.flagSection.marginHeight = 0;
        this.flagSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.flagSection);
        Composite flagClient = this.toolkit.createComposite((Composite)this.flagSection, 64);
        GridLayout flagLayout = new GridLayout();
        flagLayout.numColumns = 1;
        flagLayout.marginWidth = 0;
        flagLayout.marginHeight = 0;
        flagClient.setLayout((Layout)flagLayout);
        this.flagSection.setClient((Control)flagClient);
        this.isObsoleteText = this.toolkit.createLabel(flagClient, Messages.getString("MatchingRuleUseDescriptionDetailsPage.Obsolete"), 32);
        this.isObsoleteText.setLayoutData((Object)new GridData(768));
        this.isObsoleteText.setEnabled(false);
        this.appliesSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.appliesSection.setText(Messages.getString("MatchingRuleUseDescriptionDetailsPage.Applies"));
        this.appliesSection.marginWidth = 0;
        this.appliesSection.marginHeight = 0;
        this.appliesSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.appliesSection);
        this.appliesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        super.createRawSection();
    }

    @Override
    public void setInput(Object input) {
        MatchingRuleUse mrud = null;
        if (input instanceof MatchingRuleUse) {
            mrud = (MatchingRuleUse)input;
        }
        this.createMainContent(mrud);
        this.isObsoleteText.setEnabled(mrud != null && mrud.isObsolete());
        this.createAppliesContents(mrud);
        super.createRawContents((AbstractSchemaObject)mrud);
        this.detailForm.reflow(true);
    }

    private void createMainContent(MatchingRuleUse mrud) {
        if (this.mainSection.getClient() != null) {
            this.mainSection.getClient().dispose();
        }
        Composite mainClient = this.toolkit.createComposite((Composite)this.mainSection, 64);
        GridLayout mainLayout = new GridLayout(2, false);
        mainClient.setLayout((Layout)mainLayout);
        this.mainSection.setClient((Control)mainClient);
        if (mrud != null) {
            this.toolkit.createLabel(mainClient, Messages.getString("MatchingRuleUseDescriptionDetailsPage.NumericOID"), 0);
            this.numericOidText = this.toolkit.createText(mainClient, this.getNonNullString(mrud.getOid()), 0);
            this.numericOidText.setLayoutData((Object)new GridData(768));
            this.numericOidText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("MatchingRuleUseDescriptionDetailsPage.MatchingRules"), 0);
            this.nameLink = this.toolkit.createHyperlink(mainClient, "", 64);
            this.nameLink.setLayoutData((Object)new GridData(768));
            this.nameLink.addHyperlinkListener((IHyperlinkListener)this);
            Schema schema = this.getSchema();
            MatchingRule mrd = schema.hasMatchingRuleDescription(mrud.getOid()) ? schema.getMatchingRuleDescription(mrud.getOid()) : null;
            this.nameLink.setText(this.getNonNullString(mrd != null ? SchemaUtils.toString((AbstractSchemaObject)mrd) : SchemaUtils.toString((AbstractSchemaObject)mrud)));
            this.nameLink.setHref((Object)mrd);
            this.nameLink.setUnderlined(mrd != null);
            this.nameLink.setEnabled(mrd != null);
            this.toolkit.createLabel(mainClient, Messages.getString("MatchingRuleUseDescriptionDetailsPage.Description"), 0);
            this.descText = this.toolkit.createText(mainClient, this.getNonNullString(mrud.getDescription()), 66);
            GridData gd = new GridData(768);
            gd.widthHint = this.detailForm.getForm().getSize().x - 100 - 60;
            this.descText.setLayoutData((Object)gd);
            this.descText.setEditable(false);
        }
        this.mainSection.layout();
    }

    private void createAppliesContents(MatchingRuleUse mrud) {
        if (this.appliesSection.getClient() != null) {
            this.appliesSection.getClient().dispose();
        }
        Composite appliesClient = this.toolkit.createComposite((Composite)this.appliesSection, 64);
        appliesClient.setLayout((Layout)new GridLayout());
        this.appliesSection.setClient((Control)appliesClient);
        if (mrud != null) {
            List names = mrud.getApplicableAttributeOids();
            if (names != null && !names.isEmpty()) {
                this.appliesSection.setText(NLS.bind((String)Messages.getString("MatchingRuleUseDescriptionDetailsPage.AppliesCount"), (Object[])new Object[]{names.size()}));
                Schema schema = this.getSchema();
                for (String name : names) {
                    if (schema.hasAttributeTypeDescription(name)) {
                        AttributeType appliesAtd = schema.getAttributeTypeDescription(name);
                        Hyperlink appliesLink = this.toolkit.createHyperlink(appliesClient, SchemaUtils.toString((AbstractSchemaObject)appliesAtd), 64);
                        appliesLink.setHref((Object)appliesAtd);
                        appliesLink.setLayoutData((Object)new GridData(768));
                        appliesLink.setUnderlined(true);
                        appliesLink.setEnabled(true);
                        appliesLink.addHyperlinkListener((IHyperlinkListener)this);
                        continue;
                    }
                    Hyperlink appliesLink = this.toolkit.createHyperlink(appliesClient, name, 64);
                    appliesLink.setHref(null);
                    appliesLink.setUnderlined(false);
                    appliesLink.setEnabled(false);
                }
            } else {
                this.appliesSection.setText(NLS.bind((String)Messages.getString("MatchingRuleUseDescriptionDetailsPage.AppliesCount"), (Object[])new Object[]{0}));
                Text usedFromText = this.toolkit.createText(appliesClient, this.getNonNullString(null), 0);
                usedFromText.setLayoutData((Object)new GridData(768));
                usedFromText.setEditable(false);
            }
        } else {
            this.appliesSection.setText(Messages.getString("MatchingRuleUseDescriptionDetailsPage.Applies"));
        }
        this.appliesSection.layout();
    }
}

