/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ModificationLogsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enableModificationLogging;
    private Text logFileCountText;
    private Text logFileSizeText;
    private Text maskedAttributesText;

    public ModificationLogsPreferencePage() {
        super(Messages.getString("ModificationLogsPreferencePage.ModificationLogs"));
        super.setPreferenceStore(BrowserUIPlugin.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("ModificationLogsPreferencePage.GeneralSettingsModificationLogs"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.enableModificationLogging = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("ModificationLogsPreferencePage.EnableModificationLogs"), (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group maskedAttributesGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("ModificationLogsPreferencePage.MaskedAttributes"), (int)1);
        Composite maskedAttributesComposite = BaseWidgetUtils.createColumnContainer((Composite)maskedAttributesGroup, (int)1, (int)1);
        this.maskedAttributesText = BaseWidgetUtils.createText((Composite)maskedAttributesComposite, (String)"", (int)1);
        String maskedAttributesHelp = Messages.getString("ModificationLogsPreferencePage.CommaSeparatedList");
        BaseWidgetUtils.createWrappedLabel((Composite)maskedAttributesComposite, (String)maskedAttributesHelp, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group rotateGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("ModificationLogsPreferencePage.LogFileRotation"), (int)1);
        Composite rotateComposite = BaseWidgetUtils.createColumnContainer((Composite)rotateGroup, (int)5, (int)1);
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("ModificationLogsPreferencePage.Use"), (int)1);
        this.logFileCountText = BaseWidgetUtils.createText((Composite)rotateComposite, (String)"", (int)3, (int)1);
        this.logFileCountText.addVerifyListener(e -> {
            if (!e.text.matches("[0-9]*")) {
                e.doit = false;
            }
            if ("".equals(this.logFileCountText.getText()) && e.text.matches("[0]")) {
                e.doit = false;
            }
        });
        this.logFileCountText.addModifyListener(e -> this.validate());
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("ModificationLogsPreferencePage.LogFilesEach"), (int)1);
        this.logFileSizeText = BaseWidgetUtils.createText((Composite)rotateComposite, (String)"", (int)5, (int)1);
        this.logFileSizeText.addVerifyListener(e -> {
            if (!e.text.matches("[0-9]*")) {
                e.doit = false;
            }
            if ("".equals(this.logFileSizeText.getText()) && e.text.matches("[0]")) {
                e.doit = false;
            }
        });
        this.logFileSizeText.addModifyListener(e -> this.validate());
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("ModificationLogsPreferencePage.KB"), (int)1);
        this.setValues();
        this.applyDialogFont(composite);
        return composite;
    }

    private void setValues() {
        this.enableModificationLogging.setSelection(ConnectionCorePlugin.getDefault().isModificationLogsEnabled());
        this.maskedAttributesText.setText(ConnectionCorePlugin.getDefault().getMModificationLogsMaskedAttributes());
        this.logFileCountText.setText("" + ConnectionCorePlugin.getDefault().getModificationLogsFileCount());
        this.logFileSizeText.setText("" + ConnectionCorePlugin.getDefault().getModificationLogsFileSize());
    }

    public void validate() {
        this.setValid(this.logFileCountText.getText().matches("[0-9]+") && this.logFileSizeText.getText().matches("[0-9]+"));
    }

    public boolean performOk() {
        IEclipsePreferences instancePreferences = ConnectionCorePlugin.getDefault().getInstanceScopePreferences();
        instancePreferences.putBoolean("modificationLogsEnable", this.enableModificationLogging.getSelection());
        instancePreferences.put("modificationLogsMaskedAttributes", this.maskedAttributesText.getText());
        instancePreferences.putInt("modificationLogsFileCount", Integer.parseInt(this.logFileCountText.getText()));
        instancePreferences.putInt("modificationLogsFileSize", Integer.parseInt(this.logFileSizeText.getText()));
        ConnectionCorePlugin.getDefault().flushInstanceScopePreferences();
        return true;
    }

    protected void performDefaults() {
        IEclipsePreferences instancePreferences = ConnectionCorePlugin.getDefault().getInstanceScopePreferences();
        instancePreferences.remove("modificationLogsEnable");
        instancePreferences.remove("modificationLogsMaskedAttributes");
        instancePreferences.remove("modificationLogsFileCount");
        instancePreferences.remove("modificationLogsFileSize");
        ConnectionCorePlugin.getDefault().flushInstanceScopePreferences();
        this.setValues();
        super.performDefaults();
    }
}

