/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.control;

import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.DelAccessMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.model.Warning;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.realm.J2eePolicyMgr;
import org.apache.directory.fortress.web.control.WicketSession;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)SecUtils.class.getName());
    private static final String PERMS_CACHED = "perms.cached";
    public static final boolean IS_PERM_CACHED = Config.getInstance().getProperty("perms.cached") != null && Config.getInstance().getProperty("perms.cached").equalsIgnoreCase("true");

    public static Session getSession(Component component) {
        return ((WicketSession)component.getSession()).getSession();
    }

    public static Session createSession(AccessMgr accessMgr, String userId) {
        Session session;
        try {
            session = accessMgr.createSession(new User(userId), true);
            String message = "RBAC Session successfully created for userId: " + session.getUserId();
            LOG.debug(message);
        }
        catch (SecurityException se) {
            String error = "createSession caught SecurityException=" + se;
            LOG.error(error);
            throw new RuntimeException(error);
        }
        return session;
    }

    public static void loadPermissionsIntoSession(DelAccessMgr delAccessMgr, Session session) {
        try {
            ((WicketSession)WicketSession.get()).setSession(session);
            List permissions = delAccessMgr.sessionPermissions(session);
            ((WicketSession)WicketSession.get()).setPermissions(permissions);
            String message = "Session successfully created for userId: " + session.getUserId();
            LOG.debug(message);
        }
        catch (SecurityException se) {
            String error = "loadPermissionsIntoSession caught SecurityException=" + se;
            LOG.error(error);
            throw new RuntimeException(error);
        }
    }

    public static List<Permission> getPermissions(Component component) {
        List perms;
        try {
            WicketSession wSess = (WicketSession)component.getSession();
            perms = wSess.getPermissions();
        }
        catch (Exception e) {
            String error = "getPermissions caught Exception=" + e;
            LOG.error(error);
            throw new RuntimeException(error);
        }
        return perms;
    }

    public static void getPermissions(Component component, AccessMgr accessMgr) {
        try {
            if (IS_PERM_CACHED) {
                WicketSession session = (WicketSession)component.getSession();
                List permissions = accessMgr.sessionPermissions(session.getSession());
                ((WicketSession)WicketSession.get()).setPermissions(permissions);
            }
        }
        catch (SecurityException se) {
            String error = "getPermissions caught SecurityException=" + se;
            LOG.error(error);
            throw new RuntimeException(error);
        }
    }

    public static boolean isAuthorized(String roleName, HttpServletRequest servletReq) {
        boolean isAuthorized = false;
        if (servletReq.isUserInRole(roleName)) {
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public static boolean isFound(Permission permission, Component component) {
        List permissions = SecUtils.getPermissions((Component)component);
        return CollectionUtils.isNotEmpty((Collection)permissions) && permissions.contains(permission);
    }

    public static boolean checkAccess(Component component, AccessMgr accessMgr, String objName, String opName, String objId) throws SecurityException {
        WicketSession session = (WicketSession)component.getSession();
        Permission permission = new Permission(objName, opName, objId);
        return accessMgr.checkAccess(session.getSession(), permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeSession(Component component, J2eePolicyMgr j2eePolicyMgr, AccessMgr accessMgr, String szPrincipal) throws SecurityException {
        Session realmSession = null;
        if (j2eePolicyMgr == null || accessMgr == null) {
            throw new SecurityException(205, "initializeSession failed - verify the injection of fortress spring beans into your application");
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)szPrincipal)) {
                realmSession = j2eePolicyMgr.deserialize(szPrincipal);
            }
        }
        catch (SecurityException se) {
            throw new RuntimeException(se);
        }
        if (realmSession != null) {
            WicketSession wicketSession = (WicketSession)WicketSession.get();
            synchronized (wicketSession) {
                if (SecUtils.getSession((Component)component) == null) {
                    LOG.info("realmSession user: " + realmSession.getUserId());
                    ((WicketSession)WicketSession.get()).setSession(realmSession);
                    SecUtils.getPermissions((Component)component, (AccessMgr)accessMgr);
                }
            }
        }
    }

    public static boolean addActiveRole(Component component, AjaxRequestTarget target, AccessMgr accessMgr, String roleName) {
        boolean isSuccessful = false;
        try {
            WicketSession session = (WicketSession)component.getSession();
            session.getSession().setWarnings(null);
            accessMgr.addActiveRole(session.getSession(), new UserRole(roleName));
            List warnings = session.getSession().getWarnings();
            if (CollectionUtils.isNotEmpty((Collection)warnings)) {
                for (Warning warning : warnings) {
                    LOG.info("Warning: " + warning.getMsg() + " errCode: " + warning.getId() + " name: " + warning.getName() + " type: " + warning.getType().toString());
                    if (warning.getType() != Warning.Type.ROLE || !warning.getName().equalsIgnoreCase(roleName)) continue;
                    String error = warning.getMsg() + " code: " + warning.getId();
                    LOG.error(error);
                    target.appendJavaScript((CharSequence)(";alert('" + error + "');"));
                    return false;
                }
            }
            SecUtils.getPermissions((Component)component, (AccessMgr)accessMgr);
            isSuccessful = true;
            String message = "Activate role name: " + roleName + " successful";
            LOG.info(message);
        }
        catch (SecurityException se) {
            String msg = "Role selection " + roleName + " activation failed because of ";
            msg = se.getErrorId() == 5097 ? msg + "Dynamic SoD rule violation" : (se.getErrorId() == 2011 ? msg + "Role already active in Session" : msg + "System error: " + se + ", errId=" + se.getErrorId());
            LOG.error(msg);
            target.appendJavaScript((CharSequence)(";alert('" + msg + "');"));
        }
        return isSuccessful;
    }

    public static boolean dropActiveRole(Component component, AjaxRequestTarget target, AccessMgr accessMgr, String roleName) {
        boolean isSuccessful = false;
        try {
            WicketSession session = (WicketSession)component.getSession();
            accessMgr.dropActiveRole(session.getSession(), new UserRole(roleName));
            SecUtils.getPermissions((Component)component, (AccessMgr)accessMgr);
            isSuccessful = true;
            LOG.info("Fortress dropActiveRole roleName: " + roleName + " was successful");
        }
        catch (SecurityException se) {
            String msg = "Role selection " + roleName + " deactivation failed because of ";
            msg = se.getErrorId() == 2022 ? msg + "Role not active in session" : msg + "System error: " + se + ", errId=" + se.getErrorId();
            LOG.error(msg);
            target.appendJavaScript((CharSequence)(";alert('" + msg + "');"));
        }
        return isSuccessful;
    }

    public static void enableFortress(Component component, HttpServletRequest servletReq, J2eePolicyMgr j2eePolicyMgr, AccessMgr accessMgr) throws SecurityException {
        boolean isSecured;
        Principal principal = servletReq.getUserPrincipal();
        boolean bl = isSecured = principal != null;
        if (isSecured && !SecUtils.isLoggedIn((Component)component)) {
            String szPrincipal = principal.toString();
            SecUtils.initializeSession((Component)component, (J2eePolicyMgr)j2eePolicyMgr, (AccessMgr)accessMgr, (String)szPrincipal);
        }
    }

    public static boolean isLoggedIn(Component component) {
        boolean isLoggedIn = false;
        if (SecUtils.getSession((Component)component) != null) {
            isLoggedIn = true;
        }
        return isLoggedIn;
    }

    public static Permission getPermFromId(String id) {
        Permission perm = null;
        String[] parts = id.split("\\.");
        if (parts.length > 1) {
            String objName = parts[0];
            String opName = parts[1];
            perm = new Permission(objName, opName);
        }
        return perm;
    }
}

