/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util.cache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import org.apache.directory.fortress.core.CfgRuntimeException;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.EhCacheImpl;

class CacheFactory {
    private static final String CLS_NM = CacheFactory.class.getName();

    CacheFactory() {
    }

    public static Cache createInstance(String name, CacheManager cacheManager) {
        Ehcache cache = cacheManager.getEhcache(name);
        if (cache == null) {
            String error = "createInstance cache: " + name + " is null";
            throw new CfgRuntimeException(129, error);
        }
        BlockingCache blockingCache = new BlockingCache(cache);
        blockingCache.setTimeoutMillis(60000);
        cacheManager.replaceCacheWithDecoratedCache(cache, (Ehcache)blockingCache);
        return new EhCacheImpl(name, blockingCache);
    }
}

