/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.ant;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.PropUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAnt
extends User {
    private static final long serialVersionUID = 1L;
    private String userProps;
    private String email;
    private String phone;
    private String mobile;
    private String city;
    private String state;
    private String addresses;
    private String postalCode;
    private String postOfficeBox;
    private String building;
    private String departmentNumber;
    private String roomNumber;
    private String photo;
    private static final String CLS_NM = UserAnt.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private String country;

    public String getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
        StringTokenizer tkn = new StringTokenizer(addresses, ",");
        if (tkn.countTokens() > 0) {
            while (tkn.hasMoreTokens()) {
                String aTkn = tkn.nextToken();
                this.getAddress().setAddress(aTkn);
            }
        }
    }

    public String getUserProps() {
        return this.userProps;
    }

    public void setUserProps(String userProps) {
        this.userProps = userProps;
        this.addProperties(PropUtil.getProperties(userProps));
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.getAddress().setPostalCode(postalCode);
    }

    public String getPostOfficeBox() {
        return this.postOfficeBox;
    }

    public void setPostOfficeBox(String postOfficeBox) {
        this.getAddress().setPostOfficeBox(postOfficeBox);
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.getAddress().setBuilding(building);
    }

    public String getDepartmentNumber() {
        return this.departmentNumber;
    }

    public void setDepartmentNumber(String departmentNumber) {
        this.getAddress().setDepartmentNumber(departmentNumber);
    }

    public String getRoomNumber() {
        return this.roomNumber;
    }

    public void setRoomNumber(String roomNumber) {
        this.getAddress().setRoomNumber(roomNumber);
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.getAddress().setCity(city);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.getAddress().setState(state);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.getAddress().setCountry(country);
    }

    public String getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(String phone) {
        this.phone = phone;
        StringTokenizer tkn = new StringTokenizer(phone, ",");
        if (tkn.countTokens() > 0) {
            while (tkn.hasMoreTokens()) {
                String pTkn = tkn.nextToken();
                this.getPhones().add(pTkn);
            }
        }
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
        StringTokenizer tkn = new StringTokenizer(email, ",");
        if (tkn.countTokens() > 0) {
            while (tkn.hasMoreTokens()) {
                String eTkn = tkn.nextToken();
                this.getEmails().add(eTkn);
            }
        }
    }

    public String getMobile() {
        return this.mobile;
    }

    @Override
    public void setMobile(String mobile) {
        this.mobile = mobile;
        StringTokenizer tkn = new StringTokenizer(mobile, ",");
        if (tkn.countTokens() > 0) {
            while (tkn.hasMoreTokens()) {
                String pTkn = tkn.nextToken();
                this.getMobiles().add(pTkn);
            }
        }
    }

    public String getPhoto() {
        return this.photo;
    }

    public void setPhoto(String photo) {
        byte[] jpeg;
        this.photo = photo;
        if (StringUtils.isNotEmpty((CharSequence)photo) && ArrayUtils.isNotEmpty((byte[])(jpeg = UserAnt.getJpegPhoto(photo)))) {
            this.setJpegPhoto(jpeg);
        }
    }

    private static byte[] getJpegPhoto(String fileName) {
        byte[] value = null;
        try {
            value = UserAnt.readJpegFile(fileName);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return value;
    }

    public static byte[] readJpegFile(String fileName) {
        URL fUrl = UserAnt.class.getClassLoader().getResource(fileName);
        byte[] image = null;
        try {
            if (fUrl != null) {
                image = FileUtils.readFileToByteArray((File)new File(fUrl.toURI()));
            }
        }
        catch (URISyntaxException se) {
            String warn = "readJpegFile caught URISyntaxException=" + se;
            LOG.warn(warn);
        }
        catch (IOException ioe) {
            String warn = "readJpegFile caught IOException=" + ioe;
            LOG.warn(warn);
        }
        return image;
    }
}

