/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics.interceptors;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.metrics.ExchangeMetrics;
import org.apache.cxf.metrics.MetricsContext;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;

public abstract class AbstractMetricsInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final String REST_METRICS_MAP = AbstractMetricsInterceptor.class.getName() + ".METRICS_MAP";
    MetricsProvider[] providers;

    public AbstractMetricsInterceptor(String phase, MetricsProvider[] p) {
        super(phase);
        this.providers = p;
    }

    protected Collection<? extends MetricsProvider> getMetricProviders(Bus bus) {
        if (this.providers != null) {
            return Arrays.asList(this.providers);
        }
        ConfiguredBeanLocator b = (ConfiguredBeanLocator)bus.getExtension(ConfiguredBeanLocator.class);
        if (b == null) {
            return Collections.emptyList();
        }
        return b.getBeansOfType(MetricsProvider.class);
    }

    protected ExchangeMetrics getExchangeMetrics(Message m, boolean create) {
        ExchangeMetrics ctx = (ExchangeMetrics)m.getExchange().get(ExchangeMetrics.class);
        if (ctx == null && create) {
            ctx = new ExchangeMetrics(m.getExchange());
            m.getExchange().put(ExchangeMetrics.class, (Object)ctx);
            this.addEndpointMetrics(ctx, m);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEndpointMetrics(ExchangeMetrics ctx, Message m) {
        Endpoint ep = m.getExchange().getEndpoint();
        Object o = ep.get((Object)MetricsContext.class.getName());
        if (o == null) {
            Endpoint endpoint = ep;
            synchronized (endpoint) {
                o = this.createEndpointMetrics(m);
            }
        }
        if (o instanceof List) {
            List list = CastUtils.cast((List)((List)o));
            for (MetricsContext c : list) {
                ctx.addContext(c);
            }
        } else if (o instanceof MetricsContext) {
            ctx.addContext((MetricsContext)o);
        }
    }

    private Object createEndpointMetrics(Message m) {
        Endpoint ep = m.getExchange().getEndpoint();
        ArrayList<MetricsContext> o = ep.get((Object)MetricsContext.class.getName());
        if (o == null) {
            ArrayList<MetricsContext> contexts = new ArrayList<MetricsContext>();
            for (MetricsProvider metricsProvider : this.getMetricProviders(m.getExchange().getBus())) {
                MetricsContext c = metricsProvider.createEndpointContext(ep, MessageUtils.isRequestor((Message)m), (String)m.getContextualProperty("MetricsProvider.CLIENT_ID"));
                if (c != null) {
                    contexts.add(c);
                }
                if (!(c instanceof Closeable)) continue;
                ep.addCleanupHook((Closeable)((Object)c));
            }
            o = contexts.size() == 1 ? contexts.get(0) : contexts;
            ep.put((Object)MetricsContext.class.getName(), o);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getRestMetricsMap(Endpoint e) {
        Endpoint endpoint = e;
        synchronized (endpoint) {
            Object mmo = e.get((Object)REST_METRICS_MAP);
            if (mmo == null) {
                e.put((Object)REST_METRICS_MAP, new ConcurrentHashMap());
                mmo = e.get((Object)REST_METRICS_MAP);
            }
            return CastUtils.cast((Map)((Map)mmo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOperationMetrics(ExchangeMetrics ctx, Message m, BindingOperationInfo boi) {
        Object metrics = null;
        if (boi == null) {
            nameProperty = m.getExchange().get((Object)"org.apache.cxf.resource.operation.name");
            if (nameProperty != null && (metrics = this.getRestMetricsMap(m.getExchange().getEndpoint()).get(nameProperty.toString())) == null) {
                metrics = this.createMetricsContextForRestResource(m, nameProperty.toString());
            }
        } else {
            if (boi.isUnwrapped()) {
                boi = boi.getWrappedOperation();
            }
            if ((metrics = boi.getProperty(MetricsContext.class.getName())) == null) {
                nameProperty = boi;
                synchronized (nameProperty) {
                    metrics = this.createMetricsContextForOperation(m, boi);
                }
            }
        }
        if (metrics instanceof List) {
            List list = CastUtils.cast((List)((List)metrics));
            for (MetricsContext c : list) {
                ctx.addContext(c);
            }
        } else if (metrics instanceof MetricsContext) {
            ctx.addContext((MetricsContext)metrics);
        }
    }

    private synchronized Object createMetricsContextForRestResource(Message message, String resource) {
        Map<String, Object> restMap = this.getRestMetricsMap(message.getExchange().getEndpoint());
        ArrayList<MetricsContext> o = restMap.get(resource);
        if (o != null) {
            return o;
        }
        ArrayList<MetricsContext> contexts = new ArrayList<MetricsContext>();
        for (MetricsProvider metricsProvider : this.getMetricProviders(message.getExchange().getBus())) {
            MetricsContext c = metricsProvider.createResourceContext(message.getExchange().getEndpoint(), resource, MessageUtils.isRequestor((Message)message), (String)message.getContextualProperty("MetricsProvider.CLIENT_ID"));
            if (c != null) {
                contexts.add(c);
            }
            if (!(c instanceof Closeable)) continue;
            message.getExchange().getEndpoint().addCleanupHook((Closeable)((Object)c));
        }
        o = contexts.size() == 1 ? contexts.get(0) : contexts;
        restMap.put(resource, o);
        return o;
    }

    private Object createMetricsContextForOperation(Message message, BindingOperationInfo boi) {
        ArrayList<MetricsContext> o = boi.getProperty(MetricsContext.class.getName());
        if (o == null) {
            ArrayList<MetricsContext> contexts = new ArrayList<MetricsContext>();
            for (MetricsProvider metricsProvider : this.getMetricProviders(message.getExchange().getBus())) {
                MetricsContext c = metricsProvider.createOperationContext(message.getExchange().getEndpoint(), boi, MessageUtils.isRequestor((Message)message), (String)message.getContextualProperty("MetricsProvider.CLIENT_ID"));
                if (c != null) {
                    contexts.add(c);
                }
                if (!(c instanceof Closeable)) continue;
                message.getExchange().getEndpoint().addCleanupHook((Closeable)((Object)c));
            }
            o = contexts.size() == 1 ? contexts.get(0) : contexts;
            boi.setProperty(MetricsContext.class.getName(), o);
        }
        return o;
    }

    public void stop(Message m) {
        ExchangeMetrics ctx = this.getExchangeMetrics(m, false);
        if (ctx != null) {
            ctx.stop();
        }
    }
}

