/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public enum SigningAlgorithm {
    HS2019("hs2019", null),
    RSA_SHA1("rsa-sha1", new HashSet<Algorithm>(Arrays.asList(Algorithm.RSA_SHA1))),
    RSA_SHA256("rsa-sha256", new HashSet<Algorithm>(Arrays.asList(Algorithm.RSA_SHA256))),
    ECDSA_SHA256("ecdsa-sha256", new HashSet<Algorithm>(Arrays.asList(Algorithm.ECDSA_SHA256))),
    HMAC_SHA256("hmac-sha256", new HashSet<Algorithm>(Arrays.asList(Algorithm.HMAC_SHA256)));

    private static final Map<String, SigningAlgorithm> aliases;
    private final String algorithmName;
    private final Set<Algorithm> supportedAlgorithms;

    private SigningAlgorithm(String algorithmName, Set<Algorithm> supportedAlgorithms) {
        this.algorithmName = algorithmName;
        this.supportedAlgorithms = supportedAlgorithms != null ? Collections.unmodifiableSet(supportedAlgorithms) : null;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public Set<Algorithm> getSupportedAlgorithms() {
        return this.supportedAlgorithms;
    }

    public static SigningAlgorithm get(String name) {
        SigningAlgorithm algorithmName = aliases.get(name);
        if (algorithmName != null) {
            return algorithmName;
        }
        throw new UnsupportedAlgorithmException(name);
    }

    public String toString() {
        return this.getAlgorithmName();
    }

    static {
        aliases = new HashMap<String, SigningAlgorithm>();
        for (SigningAlgorithm algorithmName : SigningAlgorithm.values()) {
            aliases.put(algorithmName.getAlgorithmName(), algorithmName);
        }
    }
}

