/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.httpsignature.exception.DifferentDigestsException;
import org.apache.cxf.rs.security.httpsignature.exception.DigestFailureException;
import org.apache.cxf.rs.security.httpsignature.exception.MissingDigestException;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;

public class DigestVerifier {
    private static final Logger LOG = LogUtils.getL7dLogger(DigestVerifier.class);

    public void inspectDigest(byte[] messageBody, Map<String, List<String>> responseHeaders) {
        LOG.fine("Starting digest verification");
        if (responseHeaders.containsKey("Digest")) {
            MessageDigest messageDigest = SignatureHeaderUtils.createMessageDigestWithAlgorithm(this.splitDigestHeader(responseHeaders.get("Digest").get(0)).get(0));
            messageDigest.update(messageBody);
            byte[] generatedDigest = messageDigest.digest();
            byte[] headerDigest = Base64.getDecoder().decode(this.splitDigestHeader(responseHeaders.get("Digest").get(0)).get(1));
            if (!Arrays.equals(generatedDigest, headerDigest)) {
                throw new DifferentDigestsException("the digest does not match the body of the message");
            }
        } else {
            throw new MissingDigestException("found no digest header");
        }
        LOG.fine("Finished digest verification");
    }

    private List<String> splitDigestHeader(String digestHeader) {
        List<String> items = Arrays.asList(digestHeader.split("=", 2));
        if (items.size() != 2) {
            throw new DigestFailureException("invalid digest header format");
        }
        return items;
    }
}

