/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.dictionary.lookup.DictionaryException;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.ae.UmlsToSnomedConsumerImpl;
import org.apache.ctakes.dictionary.lookup.lucene.LuceneDictionaryImpl;
import org.apache.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;

public class UmlsToSnomedLuceneConsumerImpl
extends UmlsToSnomedConsumerImpl {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    private static int iv_maxListSize;
    private final String SNOMED_MAPPING_PRP_KEY = "snomedCodeMappingField";
    private final String CUI_MAPPING_PRP_KEY = "cuiMappingField";
    private final String SNOMED_CODE_LIST_CONFIG_PARM = "CodesListIndexDirectory";
    private LuceneDictionaryImpl snomedLikeCodesIndex;

    public UmlsToSnomedLuceneConsumerImpl(UimaContext aCtx, Properties properties) throws Exception {
        this(aCtx, properties, Integer.MAX_VALUE);
    }

    public UmlsToSnomedLuceneConsumerImpl(UimaContext aCtx, Properties properties, int maxListSize) throws Exception {
        super(aCtx, properties);
        iv_maxListSize = maxListSize;
        String indexDirAbsPath = null;
        try {
            FileResource fResrc = (FileResource)aCtx.getResourceObject("CodesListIndexDirectory");
            if (fResrc == null) {
                this.logger.error((Object)"Unable to find config parm CodesListIndexDirectory.");
            }
            File indexDir = fResrc.getFile();
            indexDirAbsPath = indexDir.getAbsolutePath();
            try {
                this.logger.info((Object)("Using lucene index: " + indexDir.getAbsolutePath()));
            }
            catch (Exception e) {
                throw new AnnotatorConfigurationException((Throwable)e);
            }
            DirectoryReader indexReader = IndexReader.open((Directory)FSDirectory.open((File)indexDir));
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            String lookupFieldName = this.props.getProperty("cuiMappingField");
            this.snomedLikeCodesIndex = new LuceneDictionaryImpl(indexSearcher, lookupFieldName, iv_maxListSize);
            this.logger.info((Object)("Loaded Lucene index with " + indexReader.numDocs() + " entries."));
        }
        catch (IOException ioe) {
            this.logger.info((Object)("Lucene index: " + indexDirAbsPath));
            throw new DictionaryException(ioe);
        }
    }

    @Override
    protected Set<String> getSnomedCodes(String umlsCode) throws DictionaryException {
        HashSet<String> codeSet = new HashSet<String>();
        String valueFieldName = this.props.getProperty("snomedCodeMappingField");
        Collection<MetaDataHit> mdhCollection = this.snomedLikeCodesIndex.getEntries(umlsCode);
        for (MetaDataHit mdh : mdhCollection) {
            codeSet.add(mdh.getMetaFieldValue(valueFieldName));
        }
        return codeSet;
    }
}

