/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.core.resource.LuceneIndexReaderResource;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.ae.BaseLookupConsumerImpl;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceAccessException;

public class OrangeBookFilterConsumerImpl
extends BaseLookupConsumerImpl {
    private final Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    private static final String CODE_MF_PRP_KEY = "codeMetaField";
    private static final String CODING_SCHEME_PRP_KEY = "codingScheme";
    private static final String LUCENE_FILTER_RESRC_KEY_PRP_KEY = "luceneFilterExtResrcKey";
    private final Properties _properties;
    private final IndexSearcher _indexSearcher;
    private final int _maxListSize;

    public OrangeBookFilterConsumerImpl(UimaContext aCtx, Properties props, int maxListSize) throws ResourceAccessException, NullPointerException {
        this._properties = props;
        this._maxListSize = maxListSize;
        String resrcName = this._properties.getProperty(LUCENE_FILTER_RESRC_KEY_PRP_KEY);
        LuceneIndexReaderResource resrc = (LuceneIndexReaderResource)aCtx.getResourceObject(resrcName);
        this._indexSearcher = new IndexSearcher(resrc.getIndexReader());
    }

    public OrangeBookFilterConsumerImpl(UimaContext aCtx, Properties props) throws Exception {
        this(aCtx, props, Integer.MAX_VALUE);
    }

    @Override
    public void consumeHits(JCas jcas, Iterator<LookupHit> lhItr) throws AnalysisEngineProcessException {
        String CODE_MF = this._properties.getProperty(CODE_MF_PRP_KEY);
        Map<BaseLookupConsumerImpl.LookupHitKey, Set<LookupHit>> lookupHitMap = OrangeBookFilterConsumerImpl.createLookupHitMap(lhItr);
        for (Map.Entry<BaseLookupConsumerImpl.LookupHitKey, Set<LookupHit>> entry : lookupHitMap.entrySet()) {
            boolean isValid;
            int neBegin = entry.getKey().__start;
            int neEnd = entry.getKey().__end;
            String text = jcas.getDocumentText().substring(neBegin, neEnd).trim().toLowerCase();
            boolean bl = isValid = this.isValid("trade_name", text) || this.isValid("ingredient", text);
            if (isValid) {
                HashSet<String> validCodes = new HashSet<String>();
                for (LookupHit lookupHit : entry.getValue()) {
                    MetaDataHit mdh = lookupHit.getDictMetaDataHit();
                    String code = mdh.getMetaFieldValue(CODE_MF);
                    validCodes.add(code);
                }
                FSArray ocArr = this.createOntologyConceptArr(jcas, validCodes);
                MedicationMention neAnnot = new MedicationMention(jcas);
                neAnnot.setTypeID(1);
                neAnnot.setBegin(neBegin);
                neAnnot.setEnd(neEnd);
                neAnnot.setDiscoveryTechnique(1);
                neAnnot.setOntologyConceptArr(ocArr);
                neAnnot.addToIndexes();
                continue;
            }
            this.iv_logger.warn((Object)("Filtered out: " + text));
        }
    }

    private FSArray createOntologyConceptArr(JCas jcas, Collection<String> validCodes) {
        String CODING_SCHEME = this._properties.getProperty(CODING_SCHEME_PRP_KEY);
        FSArray ocArr = new FSArray(jcas, validCodes.size());
        int ocArrIdx = 0;
        for (String validCode : validCodes) {
            OntologyConcept oc = new OntologyConcept(jcas);
            oc.setCode(validCode);
            oc.setCodingScheme(CODING_SCHEME);
            ocArr.set(ocArrIdx, (FeatureStructure)oc);
            ++ocArrIdx;
        }
        return ocArr;
    }

    private boolean isValid(String fieldName, String text) throws AnalysisEngineProcessException {
        try {
            TermQuery q = new TermQuery(new Term(fieldName, text));
            TopDocs topDoc = this._indexSearcher.search((Query)q, this._maxListSize);
            ScoreDoc[] hits = topDoc.scoreDocs;
            return hits != null && hits.length > 0;
        }
        catch (IOException ioE) {
            throw new AnalysisEngineProcessException((Throwable)ioE);
        }
    }
}

