/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.core.util.JCasUtil;
import org.apache.ctakes.dictionary.lookup.DictionaryEngine;
import org.apache.ctakes.dictionary.lookup.ae.LookupAnnotationToJCasAdapter;
import org.apache.ctakes.dictionary.lookup.ae.LookupInitializer;
import org.apache.ctakes.dictionary.lookup.algorithms.FirstTokenPermutationImpl;
import org.apache.ctakes.dictionary.lookup.algorithms.LookupAlgorithm;
import org.apache.ctakes.dictionary.lookup.phrasebuilder.VariantPhraseBuilderImpl;
import org.apache.ctakes.dictionary.lookup.vo.LookupAnnotation;
import org.apache.ctakes.dictionary.lookup.vo.LookupToken;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ContractionToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.SymbolToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;

public class FirstTokenPermLookupInitializerImpl
implements LookupInitializer {
    private static final String TRUE_STRING = Boolean.toString(true);
    private static final String FALSE_STRING = Boolean.toString(false);
    private final Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    private static final String TEXT_MFS_PRP_KEY = "textMetaFields";
    private static final String MAX_P_LEVEL_PRP_KEY = "maxPermutationLevel";
    private static final String WINDOW_ANNOT_PRP_KEY = "windowAnnotations";
    private static final String EXC_TAGS_PRP_KEY = "exclusionTags";
    private static final String CANONICAL_VARIANT_ATTR = "canonicalATTR";
    private final Properties iv_props;
    private final int[] iv_annotTypeArr;
    private final Set<String> iv_exclusionTagSet;

    public FirstTokenPermLookupInitializerImpl(UimaContext uimaContext, Properties props) {
        String tagStr;
        this.iv_props = props;
        String windowAnnots = this.iv_props.getProperty(WINDOW_ANNOT_PRP_KEY);
        if (windowAnnots != null) {
            String[] windowAnnotArr = windowAnnots.split("\\|");
            this.iv_annotTypeArr = new int[windowAnnotArr.length];
            for (int i = 0; i < windowAnnotArr.length; ++i) {
                this.iv_annotTypeArr[i] = JCasUtil.getType((String)windowAnnotArr[i]);
            }
        } else {
            this.iv_annotTypeArr = null;
        }
        if ((tagStr = this.iv_props.getProperty(EXC_TAGS_PRP_KEY)) != null) {
            String[] tagArr;
            this.iv_exclusionTagSet = new HashSet<String>();
            for (String tag : tagArr = tagStr.split(",")) {
                this.iv_exclusionTagSet.add(tag.toLowerCase());
            }
            this.iv_logger.info((Object)("Exclusion tagset loaded: " + this.iv_exclusionTagSet));
        } else {
            this.iv_exclusionTagSet = null;
        }
    }

    @Override
    public LookupAlgorithm getLookupAlgorithm(DictionaryEngine dictEngine) throws AnnotatorInitializationException {
        String textMetaFields = this.iv_props.getProperty(TEXT_MFS_PRP_KEY);
        String[] textMetaFieldNameArr = textMetaFields == null ? new String[]{} : textMetaFields.split("\\|");
        String[] variantArr = new String[]{CANONICAL_VARIANT_ATTR};
        VariantPhraseBuilderImpl pb = new VariantPhraseBuilderImpl(variantArr, true);
        int maxPermutationLevel = Integer.parseInt(this.iv_props.getProperty(MAX_P_LEVEL_PRP_KEY));
        return new FirstTokenPermutationImpl(dictEngine, pb, textMetaFieldNameArr, maxPermutationLevel);
    }

    private boolean isTagExcluded(String tag) {
        return this.iv_exclusionTagSet != null && tag != null && this.iv_exclusionTagSet.contains(tag.toLowerCase());
    }

    @Override
    public Iterator<LookupToken> getLookupTokenIterator(JCas jcas) throws AnnotatorInitializationException {
        ArrayList<LookupAnnotationToJCasAdapter> ltList = new ArrayList<LookupAnnotationToJCasAdapter>();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        AnnotationIndex annotationIndex = indexes.getAnnotationIndex(BaseToken.type);
        for (Annotation annotation : annotationIndex) {
            WordToken wta;
            String canonicalForm;
            boolean isNonLookup;
            if (!(annotation instanceof BaseToken)) {
                this.iv_logger.warn((Object)(this.getClass().getName() + " getLookupTokenIterator(..) Annotation is not a BaseToken"));
                continue;
            }
            boolean bl = isNonLookup = annotation instanceof NewlineToken || annotation instanceof PunctuationToken || annotation instanceof ContractionToken || annotation instanceof SymbolToken;
            if (isNonLookup) continue;
            BaseToken bta = (BaseToken)annotation;
            LookupAnnotationToJCasAdapter lt = new LookupAnnotationToJCasAdapter((Annotation)bta);
            if (this.isTagExcluded(bta.getPartOfSpeech())) {
                lt.addStringAttribute("USE_FOR_LOOKUP", FALSE_STRING);
            } else {
                lt.addStringAttribute("USE_FOR_LOOKUP", TRUE_STRING);
            }
            if (bta instanceof WordToken && (canonicalForm = (wta = (WordToken)bta).getCanonicalForm()) != null) {
                lt.addStringAttribute(CANONICAL_VARIANT_ATTR, canonicalForm);
            }
            ltList.add(lt);
        }
        return ltList.iterator();
    }

    @Override
    public Iterator<Annotation> getLookupWindowIterator(JCas jcas) throws AnnotatorInitializationException {
        try {
            int windowType;
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            String objClassName = this.iv_props.getProperty(WINDOW_ANNOT_PRP_KEY);
            try {
                windowType = JCasUtil.getType((String)objClassName);
            }
            catch (IllegalArgumentException iaE) {
                throw new AnnotatorInitializationException((Throwable)iaE);
            }
            return indexes.getAnnotationIndex(windowType).iterator();
        }
        catch (Exception e) {
            throw new AnnotatorInitializationException((Throwable)e);
        }
    }

    @Override
    public Map<String, List<LookupAnnotation>> getContextMap(JCas jcas, int windowBegin, int windowEnd) throws AnnotatorInitializationException {
        if (this.iv_annotTypeArr == null) {
            return Collections.emptyMap();
        }
        ArrayList<LookupAnnotation> list = new ArrayList<LookupAnnotation>();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        for (int annotationType : this.iv_annotTypeArr) {
            FSIterator itr = indexes.getAnnotationIndex(annotationType).iterator();
            list.addAll(FirstTokenPermLookupInitializerImpl.constrainToWindow(windowBegin, windowEnd, (Iterator<Annotation>)itr));
        }
        HashMap<String, List<LookupAnnotation>> m = new HashMap<String, List<LookupAnnotation>>(1);
        m.put("WINDOW_ANNOTATIONS", list);
        return m;
    }

    private static List<LookupAnnotation> constrainToWindow(int begin, int end, Iterator<Annotation> annotItr) {
        ArrayList<LookupAnnotation> list = new ArrayList<LookupAnnotation>();
        while (annotItr.hasNext()) {
            Annotation annot = annotItr.next();
            if (annot.getBegin() < begin || annot.getEnd() > end) continue;
            list.add(new LookupAnnotationToJCasAdapter(annot));
        }
        return list;
    }

    @Override
    public List<LookupToken> getSortedLookupTokens(JCas jcas, Annotation covering) throws AnnotatorInitializationException {
        ArrayList<LookupToken> ltList = new ArrayList<LookupToken>();
        List inputList = org.apache.uima.fit.util.JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (AnnotationFS)covering);
        for (BaseToken bta : inputList) {
            WordToken wta;
            String canonicalForm;
            boolean isNonLookup;
            boolean bl = isNonLookup = bta instanceof NewlineToken || bta instanceof PunctuationToken || bta instanceof ContractionToken || bta instanceof SymbolToken;
            if (isNonLookup) continue;
            LookupAnnotationToJCasAdapter lt = new LookupAnnotationToJCasAdapter((Annotation)bta);
            if (this.isTagExcluded(bta.getPartOfSpeech())) {
                lt.addStringAttribute("USE_FOR_LOOKUP", FALSE_STRING);
            } else {
                lt.addStringAttribute("USE_FOR_LOOKUP", TRUE_STRING);
            }
            if (bta instanceof WordToken && (canonicalForm = (wta = (WordToken)bta).getCanonicalForm()) != null) {
                lt.addStringAttribute(CANONICAL_VARIANT_ATTR, canonicalForm);
            }
            ltList.add(lt);
        }
        return ltList;
    }
}

