/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.pipelines;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.assertion.eval.XMIReader;
import org.apache.ctakes.assertion.pipelines.GenerateTreeRepresentation;
import org.apache.ctakes.assertion.util.AssertionDepUtils;
import org.apache.ctakes.assertion.util.AssertionTreeUtils;
import org.apache.ctakes.assertion.util.SemanticClasses;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class GenerateDependencyRepresentation {
    protected static Options options = new Options();
    private static SemanticClasses sems = null;
    private static PrintStream out = null;
    private static Logger log = Logger.getLogger(GenerateDependencyRepresentation.class);
    public static final int UP_NODES = 2;

    public static void main(String[] args) throws UIMAException, IOException, CmdLineException {
        CmdLineParser optionParser = new CmdLineParser((Object)options);
        optionParser.parseArgument(args);
        out = new PrintStream(GenerateDependencyRepresentation.options.outFile);
        List<File> trainFiles = Arrays.asList(GenerateDependencyRepresentation.options.trainDirectory.listFiles());
        if (sems == null) {
            sems = new SemanticClasses(FileLocator.getAsStream((String)"org/apache/ctakes/assertion/all_cues.txt"));
        }
        String[] paths = new String[trainFiles.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = trainFiles.get(i).getPath();
        }
        CollectionReader reader = CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
        JCasIterator casIter = new JCasIterator(reader, new AnalysisEngine[0]);
        while (casIter.hasNext()) {
            JCas jcas = casIter.next();
            GenerateDependencyRepresentation.processDocument(jcas);
        }
        out.close();
    }

    public static void processDocument(JCas jcas) {
        log.info((Object)("Processing document: " + DocumentIDAnnotationUtil.getDocumentID((JCas)jcas)));
        Collection sents = JCasUtil.select((JCas)jcas, Sentence.class);
        Sentence lastSent = null;
        for (Sentence sent : sents) {
            List nodes = JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)sent);
            ArrayList mentions = new ArrayList(JCasUtil.selectCovered(EventMention.class, (AnnotationFS)sent));
            mentions.addAll(JCasUtil.selectCovered(EntityMention.class, (AnnotationFS)sent));
            for (IdentifiedAnnotation mention : mentions) {
                SimpleTree tree;
                if (lastSent != null && lastSent.getCoveredText().startsWith("Indications") || (tree = AssertionDepUtils.getTokenTreeString(jcas, nodes, (Annotation)mention, 2)) == null) continue;
                AssertionTreeUtils.replaceDependencyWordsWithSemanticClasses(tree, sems);
                String label = "-1";
                if (GenerateDependencyRepresentation.options.attributeType == GenerateTreeRepresentation.ATTRIBUTE.NEG && mention.getPolarity() == -1 || GenerateDependencyRepresentation.options.attributeType == GenerateTreeRepresentation.ATTRIBUTE.UNC && mention.getUncertainty() == 1) {
                    label = "+1";
                }
                out.print(label);
                out.print(" |BT| ");
                out.print(tree.toString());
                out.println(" |ET|");
                out.flush();
            }
            lastSent = sent;
        }
    }

    public static class Options {
        @Option(name="--train-dir", usage="specify the directory containing the XMI training files (for example, /NLP/Corpus/Relations/mipacq/xmi/train)", required=true)
        public File trainDirectory;
        @Option(name="--output", usage="The file to which the data points be written.", required=true)
        public File outFile;
        @Option(name="--attribute", required=false)
        public GenerateTreeRepresentation.ATTRIBUTE attributeType = GenerateTreeRepresentation.ATTRIBUTE.NEG;
    }
}

