/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk.extractors;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Predicate;
import org.apache.ctakes.typesystem.type.textsem.SemanticArgument;
import org.apache.ctakes.typesystem.type.textsem.SemanticRoleRelation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class SRLFeatureExtractor
implements FeatureExtractor1 {
    public List<Feature> extract(JCas jCas, Annotation entity) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        List sents = JCasUtil.selectCovering((JCas)jCas, Sentence.class, (int)entity.getBegin(), (int)entity.getEnd());
        if (sents != null && sents.size() > 0) {
            ArrayList<String> srlFeats = SRLFeatureExtractor.getEntityFeats(jCas, (IdentifiedAnnotation)entity, (Sentence)sents.get(0));
            for (String feat : srlFeats) {
                feats.add(new Feature((Object)feat));
            }
        }
        return feats;
    }

    public static ArrayList<String> getEntityFeats(JCas jcas, IdentifiedAnnotation ent, Sentence sent) {
        ArrayList<String> feats = new ArrayList<String>();
        List words = JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (AnnotationFS)ent);
        if (words != null && words.size() > 0) {
            List coveredNodes;
            BaseToken lastWord = (BaseToken)words.get(words.size() - 1);
            List args = JCasUtil.selectCovered((JCas)jcas, SemanticArgument.class, (AnnotationFS)lastWord);
            Predicate pred = null;
            if (args.size() > 0) {
                SemanticArgument entArg = (SemanticArgument)args.get(0);
                SemanticRoleRelation entRel = entArg.getRelation();
                pred = entRel.getPredicate();
                String feat = "pred:" + pred.getCoveredText().replace(' ', '_').toLowerCase();
                feats.add(feat);
                FSList rels = entArg.getRelation().getPredicate().getRelations();
                while (rels instanceof NonEmptyFSList) {
                    NonEmptyFSList node = (NonEmptyFSList)rels;
                    SemanticRoleRelation curRel = (SemanticRoleRelation)node.getHead();
                    SemanticArgument curArg = curRel.getArgument();
                    if (!entArg.getCoveredText().equals(curArg.getCoveredText())) {
                        feat = "SRL: " + curArg.getLabel() + ":" + curArg.getCoveredText().replace(' ', '_').toLowerCase();
                        feats.add(feat);
                    }
                    rels = node.getTail();
                }
            }
            if ((coveredNodes = JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)lastWord)).size() > 0) {
                List predNodes;
                ConllDependencyNode curNode = (ConllDependencyNode)coveredNodes.get(0);
                ConllDependencyNode predNode = null;
                if (pred != null && (predNodes = JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)pred)).size() > 0) {
                    predNode = (ConllDependencyNode)predNodes.get(0);
                }
                List allNodes = JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)sent);
                for (ConllDependencyNode node : allNodes) {
                    String feat;
                    if (node.getHead() == curNode) {
                        feat = "entpointer:" + node.getDeprel() + ":" + node.getCoveredText().replace(' ', '_').toLowerCase();
                        feats.add(feat);
                        continue;
                    }
                    if (predNode == null || node.getHead() != predNode) continue;
                    feat = "predpointer:" + node.getDeprel() + ":" + node.getCoveredText().replace(' ', '_').toLowerCase();
                    feats.add(feat);
                }
            }
        }
        return feats;
    }
}

