/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk.extractors;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.assertion.util.NegationManualDepContextAnalyzer;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class NegationDependencyFeatureExtractor
implements FeatureExtractor1<IdentifiedAnnotation> {
    NegationManualDepContextAnalyzer conAnal = new NegationManualDepContextAnalyzer();

    public List<Feature> extract(JCas jcas, IdentifiedAnnotation focusAnnotation) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        Sentence sent = null;
        List sents = JCasUtil.selectCovering((JCas)jcas, Sentence.class, (int)focusAnnotation.getBegin(), (int)focusAnnotation.getEnd());
        if (sents == null || sents.size() <= 0) {
            return feats;
        }
        sent = (Sentence)sents.get(0);
        List nodes = DependencyUtility.getDependencyNodes((JCas)jcas, (Annotation)sent);
        ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)focusAnnotation);
        try {
            boolean[] regexFeats = this.conAnal.findNegationContext(nodes, headNode);
            for (int j = 0; j < regexFeats.length; ++j) {
                if (!regexFeats[j]) continue;
                feats.add(new Feature((Object)("DepPath_" + this.conAnal.getRegexName(j))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CleartkExtractorException((Throwable)e);
        }
        return feats;
    }
}

