/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk.extractors;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.TreeFragmentFeatureExtractor;
import org.apache.ctakes.assertion.util.AssertionDepUtils;
import org.apache.ctakes.assertion.util.AssertionTreeUtils;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.util.CleartkInitializationException;

public class DependencyWordsFragmentExtractor
extends TreeFragmentFeatureExtractor {
    public DependencyWordsFragmentExtractor(String prefix, String fragsPath) throws CleartkInitializationException {
        super(prefix, fragsPath);
    }

    @Override
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation mention) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        List sents = JCasUtil.selectCovering((JCas)jCas, Sentence.class, (int)mention.getBegin(), (int)mention.getEnd());
        if (sents != null && sents.size() > 0) {
            Sentence sent = (Sentence)sents.get(0);
            List nodes = JCasUtil.selectCovered(ConllDependencyNode.class, (AnnotationFS)sent);
            SimpleTree tree = AssertionDepUtils.getTokenTreeString(jCas, nodes, (Annotation)mention, 2);
            if (tree == null) {
                System.err.println("Tree is null!");
            } else {
                AssertionTreeUtils.replaceDependencyWordsWithSemanticClasses(tree, this.sems);
                for (SimpleTree frag : this.frags) {
                    if (!TreeUtils.containsDepFragIgnoreCase((SimpleTree)tree, (SimpleTree)frag)) continue;
                    features.add(new Feature("TreeFrag_" + this.prefix, (Object)frag.toString()));
                }
            }
        }
        return features;
    }
}

