/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.ctakes.assertion.medfacts.AssertionAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.ConceptLookup;
import org.apache.ctakes.assertion.stub.Annotation;
import org.apache.ctakes.assertion.stub.AssertionAnnotation;
import org.apache.ctakes.assertion.stub.AssertionFileProcessor;
import org.apache.ctakes.assertion.stub.ConceptType;
import org.apache.ctakes.assertion.stub.LineAndTokenPosition;
import org.apache.ctakes.assertion.stub.LineTokenToCharacterOffsetConverter;
import org.apache.ctakes.assertion.stub.SingleDocumentProcessor;
import org.apache.ctakes.assertion.stub.StringHandling;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

public class Converti2b2AnnotationsToCTAKES {
    private static Logger logger = Logger.getLogger(Converti2b2AnnotationsToCTAKES.class);

    private static CAS getTypeSystemFromDescriptor(String descriptor) throws InvalidXMLException, IOException, ResourceInitializationException, CASException {
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        AnalysisEngineDescription tsDesc = xmlParser.parseAnalysisEngineDescription(new XMLInputSource(descriptor));
        return CasCreationUtils.createCas((AnalysisEngineDescription)tsDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXmi(CAS aCas, File name) throws IOException, SAXException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    public static void main(String[] args) throws IOException, InvalidXMLException, CASException, SAXException, AnalysisEngineProcessException {
        File assertionDir = new File(args[1]);
        File dir = new File(args[0]);
        File odir = new File(args[3]);
        String desc = args[2];
        for (File file : dir.listFiles()) {
            CAS cas = null;
            try {
                cas = Converti2b2AnnotationsToCTAKES.getTypeSystemFromDescriptor(desc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String contents = StringHandling.readEntireContents(file);
            String fname = file.getName();
            String outFilePath = odir + "/" + file.getName().substring(0, fname.length() - 3) + "xmi";
            File outFile = new File(outFilePath);
            String assertionFilePath = assertionDir + "/" + file.getName().substring(0, fname.length() - 3) + "ast";
            System.out.println("Assertion file path: " + assertionFilePath);
            File assertionFile = new File(assertionFilePath);
            LineTokenToCharacterOffsetConverter converter = new LineTokenToCharacterOffsetConverter(contents);
            AssertionFileProcessor assertionProcessor = new AssertionFileProcessor();
            List<Annotation> assertions = assertionProcessor.processAnnotationFile(assertionFile);
            JCas jcas = cas.getJCas();
            SingleDocumentProcessor p = new SingleDocumentProcessor();
            p.setContents(contents);
            p.preprocess();
            String[][] tokenArrays = p.getTokenArrays();
            jcas.setSofaDataString(contents, "");
            int sentNum = 0;
            int tokNum = 0;
            for (int i = 0; i < tokenArrays.length; ++i) {
                Sentence sent = new Sentence(jcas);
                LineAndTokenPosition sentStart = new LineAndTokenPosition();
                sentStart.setLine(i + 1);
                sentStart.setTokenOffset(0);
                LineAndTokenPosition sentEnd = new LineAndTokenPosition();
                sentEnd.setLine(i + 1);
                sentEnd.setTokenOffset(tokenArrays[i].length - 1);
                LineTokenToCharacterOffsetConverter.BeginAndEndCharacterOffsetPair sStart = converter.convert(sentStart);
                LineTokenToCharacterOffsetConverter.BeginAndEndCharacterOffsetPair sEnd = converter.convert(sentEnd);
                if (sStart == null || sEnd == null) {
                    sent.setBegin(0);
                    sent.setEnd(0);
                    sent.setSentenceNumber(sentNum);
                } else {
                    sent.setBegin(sStart.getBegin());
                    sent.setEnd(sEnd.getEnd() + 1);
                    sent.setSentenceNumber(sentNum);
                }
                ++sentNum;
                sent.addToIndexes();
                for (int j = 0; j < tokenArrays[i].length; ++j) {
                    WordToken tok = new WordToken(jcas);
                    LineAndTokenPosition word = new LineAndTokenPosition();
                    word.setLine(i + 1);
                    word.setTokenOffset(j);
                    LineTokenToCharacterOffsetConverter.BeginAndEndCharacterOffsetPair tPos = converter.convert(word);
                    if (tPos == null) {
                        tok.setBegin(0);
                        tok.setEnd(1);
                    } else {
                        tok.setBegin(tPos.getBegin());
                        tok.setEnd(tPos.getEnd() + 1);
                    }
                    tok.setTokenNumber(tokNum);
                    ++tokNum;
                    tok.addToIndexes();
                }
            }
            logger.info((Object)"before assertions");
            for (Annotation a : assertions) {
                logger.info((Object)"  begin assertion");
                logger.info((Object)("  assertion: " + a.toString()));
                AssertionAnnotation i2b2Assertion = (AssertionAnnotation)a;
                ConceptType conceptType = i2b2Assertion.getConceptType();
                Object entityOrEventMention = null;
                entityOrEventMention = conceptType.equals(ConceptType.TREATMENT) ? new EventMention(jcas) : new EntityMention(jcas);
                LineAndTokenPosition assertionStart = new LineAndTokenPosition();
                LineAndTokenPosition assertionEnd = new LineAndTokenPosition();
                assertionStart.setLine(a.getBegin().getLine());
                assertionStart.setTokenOffset(a.getBegin().getTokenOffset());
                assertionEnd.setLine(a.getEnd().getLine());
                assertionEnd.setTokenOffset(a.getEnd().getTokenOffset());
                entityOrEventMention.setBegin(converter.convert(assertionStart).getBegin());
                entityOrEventMention.setEnd(converter.convert(assertionEnd).getEnd());
                entityOrEventMention.setConfidence(1.0f);
                FSArray ontologyConceptArray = ConceptLookup.reverseLookup(conceptType, jcas);
                entityOrEventMention.setOntologyConceptArr(ontologyConceptArray);
                AssertionAnalysisEngine.mapI2B2AssertionValueToCtakes(i2b2Assertion.getAssertionValue().toString().toLowerCase(), (IdentifiedAnnotation)entityOrEventMention);
                entityOrEventMention.addToIndexes();
                logger.info((Object)"  end assertion");
            }
            logger.info((Object)"after assertions");
            Converti2b2AnnotationsToCTAKES.writeXmi(cas, outFile);
        }
    }

    private static void adjustAssertionAttributesByI2B2Convertion(IdentifiedAnnotation entityOrEventMention, AssertionAnnotation i2b2Assertion) {
    }
}

