/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.ctakes.assertion.medfacts.types.Assertion;
import org.apache.ctakes.assertion.stub.CharacterOffsetToLineTokenConverterDefaultImpl;
import org.apache.ctakes.assertion.stub.LineAndTokenPosition;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;

public class ConvertXMIAssertionsToi2b2Format {
    private static CAS getTypeSystemFromDescriptor(String descriptor) throws InvalidXMLException, IOException, ResourceInitializationException, CASException {
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        AnalysisEngineDescription tsDesc = xmlParser.parseAnalysisEngineDescription(new XMLInputSource(descriptor));
        return CasCreationUtils.createCas((AnalysisEngineDescription)tsDesc);
    }

    public static void main(String[] args) throws IOException, InvalidXMLException, CASException {
        File dir = new File(args[0]);
        File odir = new File(args[2]);
        String desc = args[1];
        FileInputStream inputStream = null;
        int assertionType = Assertion.type;
        CAS cas = null;
        try {
            cas = ConvertXMIAssertionsToi2b2Format.getTypeSystemFromDescriptor(desc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (cas != null) {
            for (File file : dir.listFiles()) {
                try {
                    inputStream = new FileInputStream(file);
                    PrintWriter writer = new PrintWriter(new File(odir + "/" + file.getName()));
                    XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)cas);
                    JCas jcas = cas.getJCas();
                    String sofaString = jcas.getDocumentText();
                    System.err.println("Converting text string: " + sofaString);
                    CharacterOffsetToLineTokenConverterDefaultImpl converter = new CharacterOffsetToLineTokenConverterDefaultImpl(sofaString);
                    AnnotationIndex aIndex = jcas.getAnnotationIndex(assertionType);
                    for (Annotation a : aIndex) {
                        Assertion ai = (Assertion)a;
                        int begin = ai.getBegin();
                        int end = ai.getEnd();
                        LineAndTokenPosition begPos = converter.convert(begin);
                        LineAndTokenPosition endPos = converter.convert(end);
                        writer.println("c=\"" + sofaString.substring(begin, end) + "\" " + begPos.getLine() + ":" + begPos.getTokenOffset() + " " + endPos.getLine() + ":" + endPos.getTokenOffset() + "||t=\"problem\"||a=\"" + ai.getAssertionType() + "\"");
                    }
                    writer.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        }
    }
}

