/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.attributes.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.assertion.attributes.subject.SubjectAttributeClassifier;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class SubjectFeaturesExtractor
implements FeatureExtractor1<IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg) {
        HashMap<String, Boolean> featsMap;
        ArrayList<Feature> features = new ArrayList<Feature>();
        ConllDependencyNode node = DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg);
        if (node != null) {
            features.add(new Feature("DEPENDENCY_HEAD", (Object)node.getCoveredText()));
            features.add(new Feature("DEPENDENCY_HEAD_deprel", (Object)node.getDeprel()));
        }
        if (!(featsMap = SubjectAttributeClassifier.extract(jCas, (Annotation)arg)).isEmpty()) {
            features.addAll(SubjectFeaturesExtractor.hashToFeatureList(featsMap));
            features.add(new Feature("SUBJECT_CLASSIFIER_LOGIC", (Object)SubjectAttributeClassifier.classifyWithLogic(featsMap)));
        }
        return features;
    }

    private static Collection<? extends Feature> hashToFeatureList(HashMap<String, Boolean> featsIn) {
        HashSet<Feature> featsOut = new HashSet<Feature>();
        for (String featName : featsIn.keySet()) {
            featsOut.add(new Feature(featName, (Object)featsIn.get(featName)));
        }
        return featsOut;
    }
}

