/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.annotators;

import com.mdimension.jchronic.Chronic;
import com.mdimension.jchronic.utils.Span;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.ytex.uima.types.Date;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Date Annotator", description="Annotates Dates based upon whether or not text can be normalized to a date.", dependencies={PipeBitInfo.TypeProduct.BASE_TOKEN})
public class DateAnnotator
extends JCasAnnotator_ImplBase {
    private static final Log log = LogFactory.getLog(DateAnnotator.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    String dateType;
    private ThreadLocal<SimpleDateFormat> tlDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateAnnotator.DATE_FORMAT);
        }
    };

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.dateType = (String)aContext.getConfigParameterValue("dateType");
        if (this.dateType == null) {
            this.dateType = "org.apache.ctakes.typesystem.type.textsem.DateAnnotation";
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Type t = jCas.getTypeSystem().getType(this.dateType);
        if (t != null) {
            AnnotationIndex annoIndex = jCas.getAnnotationIndex();
            for (Annotation anno : annoIndex) {
                try {
                    Span span = Chronic.parse((String)anno.getCoveredText());
                    if (span == null || span.getBeginCalendar() == null) continue;
                    Date date = new Date(jCas);
                    date.setBegin(anno.getBegin());
                    date.setEnd(anno.getEnd());
                    date.setDate(this.tlDateFormat.get().format(span.getBeginCalendar().getTime()));
                    date.addToIndexes();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("chronic failed on: " + anno.getCoveredText()), (Throwable)e);
                }
            }
        }
    }
}

