/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class WriteBytesProvider
implements Callback {
    private static final Logger LOG = Log.getLogger(WriteBytesProvider.class);
    private final Generator generator;
    private final Callback flushCallback;
    private LinkedList<FrameEntry> queue;
    private int bufferSize = 2048;
    private int gatheredBufferLimit = 10;
    private LinkedList<FrameEntry> past;
    private FrameEntry active;
    private Throwable failure;
    private AtomicBoolean closed;

    public WriteBytesProvider(Generator generator, Callback flushCallback) {
        this.generator = Objects.requireNonNull(generator);
        this.flushCallback = Objects.requireNonNull(flushCallback);
        this.queue = new LinkedList();
        this.past = new LinkedList();
        this.closed = new AtomicBoolean(false);
    }

    public void close() {
        LOG.debug(".close()", new Object[0]);
        this.closed.set(true);
        this.failAll(new EOFException("Connection has been disconnected"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Frame frame, Callback callback) {
        Objects.requireNonNull(frame);
        LOG.debug("enqueue({}, {})", frame, callback);
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            if (this.closed.get()) {
                LOG.debug("Write is closed: {} {}", frame, callback);
                if (callback != null) {
                    callback.failed(new IOException("Write is closed"));
                }
                return;
            }
            if (this.failure != null) {
                LOG.debug("Write is in failure: {} {}", frame, callback);
                this.notifySafeFailure(callback, this.failure);
                return;
            }
            FrameEntry entry = new FrameEntry(frame, callback);
            switch (frame.getOpCode()) {
                case 9: {
                    this.queue.addFirst(entry);
                    break;
                }
                case 8: {
                    this.closed.set(true);
                    this.queue.addLast(entry);
                    break;
                }
                default: {
                    this.queue.addLast(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failAll(Throwable t) {
        ArrayList<FrameEntry> callbacks = new ArrayList<FrameEntry>();
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            if (this.active != null) {
                FrameEntry entry = this.active;
                this.active = null;
                callbacks.add(entry);
            }
            callbacks.addAll(this.past);
            callbacks.addAll(this.queue);
            this.past.clear();
            this.queue.clear();
        }
        if (!callbacks.isEmpty()) {
            this.flushCallback.failed(t);
            for (FrameEntry entry : callbacks) {
                entry.notifyFailure(t);
            }
        }
    }

    @Override
    public void failed(Throwable cause) {
        this.failAll(cause);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ByteBuffer> getByteBuffers() {
        ArrayList<ByteBuffer> bufs = null;
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            for (int count = 0; count < this.gatheredBufferLimit; ++count) {
                if (this.active == null) {
                    if (this.queue.isEmpty()) {
                        return bufs;
                    }
                    this.active = this.queue.pop();
                    if (bufs == null) {
                        bufs = new ArrayList();
                    }
                    bufs.add(this.active.getHeaderBytes());
                    ++count;
                }
                if (bufs == null) {
                    bufs = new ArrayList<ByteBuffer>();
                }
                bufs.add(this.active.getPayloadWindow());
                if (!this.active.isDone()) continue;
                this.past.add(this.active);
                this.active = null;
            }
        }
        LOG.debug("Collected {} ByteBuffers", bufs.size());
        return bufs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            return this.closed.get();
        }
    }

    private void notifySafeFailure(Callback callback, Throwable t) {
        if (callback == null) {
            return;
        }
        try {
            callback.failed(t);
        }
        catch (Throwable e) {
            LOG.warn("Uncaught exception", e);
        }
    }

    public void releasePayloadBuffer(Frame frame) {
        DataFrame data;
        if (!frame.hasPayload()) {
            return;
        }
        if (frame instanceof DataFrame && (data = (DataFrame)frame).isPooledBuffer()) {
            ByteBuffer payload = frame.getPayload();
            this.generator.getBufferPool().release(payload);
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void succeeded() {
        ArrayList<FrameEntry> callbacks = new ArrayList<FrameEntry>();
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            if (this.active != null && this.active.frame.remaining() <= 0) {
                FrameEntry entry = this.active;
                this.active = null;
                callbacks.add(entry);
            }
            callbacks.addAll(this.past);
            this.past.clear();
        }
        this.flushCallback.succeeded();
        for (FrameEntry entry : callbacks) {
            entry.notifySucceeded();
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WriteBytesProvider[");
        b.append("flushCallback=").append(this.flushCallback);
        if (this.failure != null) {
            b.append(",failure=").append(this.failure.getClass().getName());
            b.append(":").append(this.failure.getMessage());
        } else {
            b.append(",active=").append(this.active);
            b.append(",queue.size=").append(this.queue.size());
            b.append(",past.size=").append(this.past.size());
        }
        b.append(']');
        return b.toString();
    }

    private class FrameEntry {
        protected final AtomicBoolean failed = new AtomicBoolean(false);
        protected final Frame frame;
        protected final Callback callback;
        private ByteBuffer headerBuffer;

        public FrameEntry(Frame frame, Callback callback) {
            this.frame = frame;
            this.callback = callback;
        }

        public ByteBuffer getHeaderBytes() {
            ByteBuffer buf;
            this.headerBuffer = buf = WriteBytesProvider.this.generator.generateHeaderBytes(this.frame);
            return buf;
        }

        public ByteBuffer getPayloadWindow() {
            return WriteBytesProvider.this.generator.getPayloadWindow(WriteBytesProvider.this.bufferSize, this.frame);
        }

        public void notifyFailure(Throwable t) {
            this.freeBuffers();
            if (!this.failed.getAndSet(true)) {
                WriteBytesProvider.this.notifySafeFailure(this.callback, t);
            }
        }

        public void notifySucceeded() {
            this.freeBuffers();
            if (this.callback == null) {
                return;
            }
            try {
                this.callback.succeeded();
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
        }

        public void freeBuffers() {
            if (this.headerBuffer != null) {
                WriteBytesProvider.this.generator.getBufferPool().release(this.headerBuffer);
                this.headerBuffer = null;
            }
            WriteBytesProvider.this.releasePayloadBuffer(this.frame);
        }

        public boolean isDone() {
            return this.frame.remaining() <= 0;
        }
    }
}

