/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.BlockingWriteCallback;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.DataFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.io.FutureWriteCallback;

public class WebSocketRemoteEndpoint
implements RemoteEndpoint {
    private static final String PRIORMSG_ERROR = "Prior message pending, cannot start new message yet.";
    private static final int NONE = 0;
    private static final int TEXT = 1;
    private static final int BINARY = 2;
    private static final int CONTROL = 3;
    private static final WriteCallback NOOP_CALLBACK = new WriteCallback(){

        @Override
        public void writeSuccess() {
        }

        @Override
        public void writeFailed(Throwable x) {
        }
    };
    private static final Logger LOG = Log.getLogger(WebSocketRemoteEndpoint.class);
    public final LogicalConnection connection;
    public final OutgoingFrames outgoing;
    private final ReentrantLock msgLock = new ReentrantLock();
    private final AtomicInteger msgType = new AtomicInteger(0);
    private boolean partialStarted = false;

    public WebSocketRemoteEndpoint(LogicalConnection connection, OutgoingFrames outgoing) {
        if (connection == null) {
            throw new IllegalArgumentException("LogicalConnection cannot be null");
        }
        this.connection = connection;
        this.outgoing = outgoing;
    }

    private void blockingWrite(WebSocketFrame frame) throws IOException {
        BlockingWriteCallback callback = new BlockingWriteCallback();
        this.sendFrame(frame, callback);
        callback.block();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.connection.getRemoteAddress();
    }

    private Future<Void> sendAsyncFrame(WebSocketFrame frame) {
        FutureWriteCallback future = new FutureWriteCallback();
        this.sendFrame(frame, future);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBytes(ByteBuffer data) throws IOException {
        if (this.msgLock.tryLock()) {
            try {
                this.msgType.set(2);
                this.connection.getIOState().assertOutputOpen();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendBytes with {}", BufferUtil.toDetailString(data));
                }
                this.blockingWrite(new BinaryFrame().setPayload(data));
            }
            finally {
                this.msgType.set(0);
                this.msgLock.unlock();
            }
        } else {
            throw new IllegalStateException(PRIORMSG_ERROR);
        }
    }

    @Override
    public Future<Void> sendBytesByFuture(ByteBuffer data) {
        this.msgType.set(2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBytesByFuture with {}", BufferUtil.toDetailString(data));
        }
        return this.sendAsyncFrame(new BinaryFrame().setPayload(data));
    }

    @Override
    public void sendBytes(ByteBuffer data, WriteCallback callback) {
        this.msgType.set(2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBytes({}, {})", BufferUtil.toDetailString(data), callback);
        }
        this.sendFrame(new BinaryFrame().setPayload(data), callback == null ? NOOP_CALLBACK : callback);
    }

    public void sendFrame(WebSocketFrame frame, WriteCallback callback) {
        try {
            this.connection.getIOState().assertOutputOpen();
            this.outgoing.outgoingFrame(frame, callback);
        }
        catch (IOException e) {
            callback.writeFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPartialBytes(ByteBuffer fragment, boolean isLast) throws IOException {
        if (this.msgLock.tryLock()) {
            try {
                if (this.msgType.get() == 1) {
                    throw new IllegalStateException("Prior TEXT message pending, cannot start new BINARY message yet.");
                }
                this.msgType.set(2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendPartialBytes({}, {})", BufferUtil.toDetailString(fragment), isLast);
                }
                DataFrame frame = null;
                frame = this.partialStarted ? new ContinuationFrame().setPayload(fragment) : new BinaryFrame().setPayload(fragment);
                frame.setFin(isLast);
                this.blockingWrite(frame);
                this.partialStarted = !isLast;
            }
            finally {
                if (isLast) {
                    this.msgType.set(0);
                }
                this.msgLock.unlock();
            }
        } else {
            throw new IllegalStateException(PRIORMSG_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        if (this.msgLock.tryLock()) {
            try {
                if (this.msgType.get() == 2) {
                    throw new IllegalStateException("Prior BINARY message pending, cannot start new TEXT message yet.");
                }
                this.msgType.set(1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendPartialString({}, {})", fragment, isLast);
                }
                DataFrame frame = null;
                frame = this.partialStarted ? new ContinuationFrame().setPayload(fragment) : new TextFrame().setPayload(fragment);
                frame.setFin(isLast);
                this.blockingWrite(frame);
                this.partialStarted = !isLast;
            }
            finally {
                if (isLast) {
                    this.msgType.set(0);
                }
                this.msgLock.unlock();
            }
        } else {
            throw new IllegalStateException(PRIORMSG_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPing(ByteBuffer applicationData) throws IOException {
        if (this.msgLock.tryLock()) {
            try {
                this.msgType.set(3);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendPing with {}", BufferUtil.toDetailString(applicationData));
                }
                this.blockingWrite(new PingFrame().setPayload(applicationData));
            }
            finally {
                this.msgType.set(0);
                this.msgLock.unlock();
            }
        } else {
            throw new IllegalStateException(PRIORMSG_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPong(ByteBuffer applicationData) throws IOException {
        if (this.msgLock.tryLock()) {
            try {
                this.msgType.set(3);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendPong with {}", BufferUtil.toDetailString(applicationData));
                }
                this.blockingWrite(new PongFrame().setPayload(applicationData));
            }
            finally {
                this.msgType.set(0);
                this.msgLock.unlock();
            }
        } else {
            throw new IllegalStateException(PRIORMSG_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendString(String text) throws IOException {
        if (this.msgLock.tryLock()) {
            try {
                this.msgType.set(1);
                TextFrame frame = new TextFrame().setPayload(text);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sendString with {}", BufferUtil.toDetailString(frame.getPayload()));
                }
                this.blockingWrite(frame);
            }
            finally {
                this.msgType.set(0);
                this.msgLock.unlock();
            }
        } else {
            throw new IllegalStateException(PRIORMSG_ERROR);
        }
    }

    @Override
    public Future<Void> sendStringByFuture(String text) {
        this.msgType.set(1);
        TextFrame frame = new TextFrame().setPayload(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendStringByFuture with {}", BufferUtil.toDetailString(frame.getPayload()));
        }
        return this.sendAsyncFrame(frame);
    }

    @Override
    public void sendString(String text, WriteCallback callback) {
        this.msgType.set(1);
        TextFrame frame = new TextFrame().setPayload(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendString({},{})", BufferUtil.toDetailString(frame.getPayload()), callback);
        }
        this.sendFrame(frame, callback == null ? NOOP_CALLBACK : callback);
    }
}

