/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.viterbi;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.cleartk.ml.Classifier;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.jar.Train;
import org.cleartk.ml.viterbi.OutcomeFeatureExtractor;
import org.cleartk.ml.viterbi.ViterbiClassifier;

public class ViterbiClassifierBuilder<OUTCOME_TYPE>
extends JarClassifierBuilder<ViterbiClassifier<OUTCOME_TYPE>> {
    private static final String OUTCOME_FEATURE_EXTRACTOR_FILE_NAME = "outcome-features-extractors.ser";
    private static final String DELEGATED_MODEL_DIRECTORY_NAME = "delegated-model";
    private static final String DELEGATED_MODEL_FILE_NAME = "delegated-model.jar";
    private OutcomeFeatureExtractor[] outcomeFeatureExtractors;
    private Classifier<OUTCOME_TYPE> delegatedClassifier;

    private static File getOutcomeFeatureExtractorsFile(File dir) {
        return new File(dir, OUTCOME_FEATURE_EXTRACTOR_FILE_NAME);
    }

    public File getDelegatedModelDirectory(File dir) {
        return new File(dir, DELEGATED_MODEL_DIRECTORY_NAME);
    }

    public void setOutcomeFeatureExtractors(OutcomeFeatureExtractor[] outcomeFeatureExtractors) {
        this.outcomeFeatureExtractors = outcomeFeatureExtractors;
    }

    @Override
    public void saveToTrainingDirectory(File dir) throws IOException {
        super.saveToTrainingDirectory(dir);
        ObjectOutputStream extractorsStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(ViterbiClassifierBuilder.getOutcomeFeatureExtractorsFile(dir))));
        extractorsStream.writeObject(this.outcomeFeatureExtractors);
        extractorsStream.close();
    }

    @Override
    public void trainClassifier(File dir, String ... args) throws Exception {
        String[] delegatedArgs = new String[args.length + 1];
        System.arraycopy(args, 0, delegatedArgs, 1, args.length);
        delegatedArgs[0] = this.getDelegatedModelDirectory(dir).getPath();
        Train.main(delegatedArgs);
    }

    @Override
    public void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry(modelStream, DELEGATED_MODEL_FILE_NAME, JarClassifierBuilder.getModelJarFile(this.getDelegatedModelDirectory(dir)));
        JarStreams.putNextJarEntry(modelStream, OUTCOME_FEATURE_EXTRACTOR_FILE_NAME, ViterbiClassifierBuilder.getOutcomeFeatureExtractorsFile(dir));
    }

    @Override
    public void unpackageClassifier(JarInputStream modelStream) throws IOException {
        JarStreams.getNextJarEntry(modelStream, DELEGATED_MODEL_FILE_NAME);
        JarInputStream delegatedModelStream = new JarInputStream(modelStream);
        Manifest delegatedManifest = delegatedModelStream.getManifest();
        JarClassifierBuilder<?> delegatedBuilder = JarClassifierBuilder.fromManifest(delegatedManifest);
        this.delegatedClassifier = this.cast(delegatedBuilder.loadClassifier(delegatedModelStream));
        JarStreams.getNextJarEntry(modelStream, OUTCOME_FEATURE_EXTRACTOR_FILE_NAME);
        ObjectInputStream objectStream = new ObjectInputStream(modelStream);
        try {
            this.outcomeFeatureExtractors = (OutcomeFeatureExtractor[])objectStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ViterbiClassifier<OUTCOME_TYPE> newClassifier() {
        return new ViterbiClassifier<OUTCOME_TYPE>(this.delegatedClassifier, this.outcomeFeatureExtractors);
    }

    private Classifier<OUTCOME_TYPE> cast(Object object) {
        Classifier classifier = (Classifier)object;
        return classifier;
    }
}

