/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.util.featurevector;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.cleartk.ml.util.featurevector.FeatureVector;
import org.cleartk.ml.util.featurevector.InvalidFeatureVectorValueException;

public class ArrayFeatureVector
extends FeatureVector {
    ArrayList<Double> features = new ArrayList();

    @Override
    public double get(int index) {
        if (index < this.features.size()) {
            return this.features.get(index);
        }
        return 0.0;
    }

    @Override
    public java.util.Iterator<FeatureVector.Entry> iterator() {
        return new Iterator(this.features);
    }

    @Override
    public void set(int index, double value) throws InvalidFeatureVectorValueException {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new InvalidFeatureVectorValueException(index, value);
        }
        for (int i = this.features.size(); i <= index; ++i) {
            this.features.add(0.0);
        }
        this.features.set(index, value);
    }

    public double[] toArray() {
        double[] result = new double[this.features.size()];
        int index = 0;
        for (Double d : this.features) {
            result[index] = d;
            ++index;
        }
        return result;
    }

    static class Iterator
    implements java.util.Iterator<FeatureVector.Entry> {
        int currentIndex = 0;
        ListIterator<Double> subIterator;

        public Iterator(List<Double> features) {
            this.subIterator = features.listIterator();
            this.moveToNext();
        }

        @Override
        public boolean hasNext() {
            return this.subIterator.hasNext();
        }

        @Override
        public FeatureVector.Entry next() {
            int index = this.subIterator.nextIndex();
            Double value = this.subIterator.next();
            this.moveToNext();
            return new FeatureVector.Entry(index, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void moveToNext() {
            while (this.subIterator.hasNext()) {
                Double d = this.subIterator.next();
                if (d == null || d == 0.0) continue;
                this.subIterator.previous();
                return;
            }
        }
    }
}

