/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.feature.function;

import java.util.Collections;
import java.util.List;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;
import org.cleartk.ml.feature.util.CaseUtil;

public class CapitalTypeFeatureFunction
implements FeatureFunction {
    public static final String DEFAULT_NAME = "CapitalType";

    public List<Feature> apply(Feature feature) {
        String featureName = Feature.createName(DEFAULT_NAME, feature.getName());
        Object featureValue = feature.getValue();
        if (featureValue == null) {
            return Collections.emptyList();
        }
        if (featureValue instanceof String) {
            String upperCaseValue;
            String value = featureValue.toString();
            if (value == null || value.length() == 0) {
                return Collections.emptyList();
            }
            String lowerCaseValue = value.toLowerCase();
            if (lowerCaseValue.equals(upperCaseValue = value.toUpperCase())) {
                return Collections.emptyList();
            }
            if (value.equals(value.toLowerCase())) {
                return Collections.singletonList(new Feature(featureName, CapitalType.ALL_LOWERCASE.toString()));
            }
            if (value.equals(value.toUpperCase())) {
                return Collections.singletonList(new Feature(featureName, CapitalType.ALL_UPPERCASE.toString()));
            }
            if (CaseUtil.isInitialUppercase(value)) {
                return Collections.singletonList(new Feature(featureName, CapitalType.INITIAL_UPPERCASE.toString()));
            }
            return Collections.singletonList(new Feature(featureName, CapitalType.MIXED_CASE.toString()));
        }
        return Collections.emptyList();
    }

    public static enum CapitalType {
        ALL_UPPERCASE,
        ALL_LOWERCASE,
        INITIAL_UPPERCASE,
        MIXED_CASE;

    }
}

