/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import org.apache.ctakes.ytex.kernel.evaluator.Kernel;
import org.apache.ctakes.ytex.kernel.tree.Node;

public class ConvolutionKernel
implements Kernel {
    private Kernel delegateKernel;
    private String nodeType;
    private double pow = 1.0;

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public Kernel getDelegateKernel() {
        return this.delegateKernel;
    }

    public void setDelegateKernel(Kernel delegateKernel) {
        this.delegateKernel = delegateKernel;
    }

    public double getPow() {
        return this.pow;
    }

    public void setPow(double pow) {
        this.pow = pow;
    }

    @Override
    public double evaluate(Object c1, Object c2) {
        Node n1 = (Node)c1;
        Node n2 = (Node)c2;
        double d = 0.0;
        for (Node child1 : n1.getChildren()) {
            for (Node child2 : n2.getChildren()) {
                if (this.getNodeType() != null && (!this.getNodeType().equals(child1.getType()) || !this.getNodeType().equals(child2.getType()))) continue;
                d += this.delegateKernel.evaluate(child1, child2);
            }
        }
        if (this.pow > 1.0) {
            return Math.pow(d, this.pow);
        }
        return d;
    }
}

