/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.dao;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.dao.DBUtil;
import org.apache.ctakes.ytex.kernel.dao.KernelEvaluationDao;
import org.apache.ctakes.ytex.kernel.model.KernelEvaluation;
import org.apache.ctakes.ytex.kernel.model.KernelEvaluationInstance;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class KernelEvaluationDaoImpl
implements KernelEvaluationDao {
    private SessionFactory sessionFactory;
    private static final Log log = LogFactory.getLog(KernelEvaluationDaoImpl.class);
    private PlatformTransactionManager transactionManager;
    private TransactionTemplate txTemplate;

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.txTemplate = new TransactionTemplate(this.transactionManager);
        this.txTemplate.setPropagationBehavior(3);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void storeNorm(KernelEvaluation kernelEvaluation, long instanceId, double norm) {
        this.storeKernel(kernelEvaluation, instanceId, instanceId, norm);
    }

    @Override
    public Double getNorm(KernelEvaluation kernelEvaluation, long instanceId) {
        return this.getKernel(kernelEvaluation, instanceId, instanceId);
    }

    @Override
    public void storeKernel(KernelEvaluation kernelEvaluation, long instanceId1, long instanceId2, double kernel) {
        long instanceId1s = instanceId1 <= instanceId2 ? instanceId1 : instanceId2;
        long instanceId2s = instanceId1 <= instanceId2 ? instanceId2 : instanceId1;
        KernelEvaluationInstance g = new KernelEvaluationInstance(kernelEvaluation.getKernelEvaluationId(), instanceId1s, instanceId2s, kernel);
        this.getSessionFactory().getCurrentSession().save((Object)g);
    }

    @Override
    public Double getKernel(KernelEvaluation kernelEvaluation, long instanceId1, long instanceId2) {
        long instanceId1s = instanceId1 <= instanceId2 ? instanceId1 : instanceId2;
        long instanceId2s = instanceId1 <= instanceId2 ? instanceId2 : instanceId1;
        Query q = this.getSessionFactory().getCurrentSession().getNamedQuery("getKernelEvaluation");
        q.setCacheable(true);
        q.setInteger("kernelEvaluationId", kernelEvaluation.getKernelEvaluationId());
        q.setLong("instanceId1", instanceId1s);
        q.setLong("instanceId2", instanceId2s);
        KernelEvaluationInstance g = (KernelEvaluationInstance)q.uniqueResult();
        if (g != null) {
            return g.getSimilarity();
        }
        return null;
    }

    @Override
    public List<KernelEvaluationInstance> getAllKernelEvaluationsForInstance(KernelEvaluation kernelEvaluation, long instanceId) {
        Query q = this.getSessionFactory().getCurrentSession().getNamedQuery("getAllKernelEvaluationsForInstance1");
        q.setInteger("kernelEvaluationId", kernelEvaluation.getKernelEvaluationId());
        q.setLong("instanceId", instanceId);
        List kevals = q.list();
        Query q2 = this.getSessionFactory().getCurrentSession().getNamedQuery("getAllKernelEvaluationsForInstance2");
        q2.setInteger("kernelEvaluationId", kernelEvaluation.getKernelEvaluationId());
        q2.setLong("instanceId", instanceId);
        kevals.addAll(q2.list());
        return kevals;
    }

    @Override
    public KernelEvaluation storeKernelEval(final KernelEvaluation kernelEvaluation) {
        KernelEvaluation kEval = this.getKernelEval(kernelEvaluation.getCorpusName(), kernelEvaluation.getExperiment(), kernelEvaluation.getLabel(), kernelEvaluation.getFoldId(), kernelEvaluation.getParam1(), kernelEvaluation.getParam2());
        if (kEval == null) {
            this.txTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus txStatus) {
                    try {
                        KernelEvaluationDaoImpl.this.getSessionFactory().getCurrentSession().save((Object)kernelEvaluation);
                    }
                    catch (Exception e) {
                        log.warn((Object)"couldn't save kernel evaluation, maybe somebody else did. try to retrieve kernel eval");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"error saving kernel eval", (Throwable)e);
                        }
                        txStatus.setRollbackOnly();
                    }
                    return null;
                }
            });
            kEval = this.getKernelEval(kernelEvaluation.getCorpusName(), kernelEvaluation.getExperiment(), kernelEvaluation.getLabel(), kernelEvaluation.getFoldId(), kernelEvaluation.getParam1(), kernelEvaluation.getParam2());
        }
        return kEval;
    }

    @Override
    public KernelEvaluation getKernelEval(String name, String experiment, String label, int foldId, double param1, String param2) {
        Query q = this.getSessionFactory().getCurrentSession().getNamedQuery("getKernelEval");
        q.setString("corpusName", name);
        q.setString("experiment", DBUtil.nullToEmptyString(experiment));
        q.setString("label", DBUtil.nullToEmptyString(label));
        q.setInteger("foldId", foldId);
        q.setDouble("param1", param1);
        q.setString("param2", DBUtil.nullToEmptyString(param2));
        return (KernelEvaluation)q.uniqueResult();
    }
}

