/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.web.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import org.apache.ctakes.ytex.kernel.metric.ConceptPair;
import org.apache.ctakes.ytex.kernel.metric.ConceptPairSimilarity;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.LCSPath;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;
import org.apache.ctakes.ytex.web.search.ConceptLookupBean;
import org.apache.ctakes.ytex.web.search.ConceptSearchService;
import org.apache.ctakes.ytex.web.search.SemanticSimRegistryBean;
import org.apache.ctakes.ytex.web.search.SemanticSimServiceBean;

public class SemanticSimBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    transient ConceptLookupBean concept1;
    transient ConceptLookupBean concept2;
    transient String conceptGraphName;
    transient String conceptPairText;
    transient String corpusLcsTerm;
    transient String exportType;
    transient String intrinsicLcsTerm;
    transient Map<String, String> lcsPathMap = new TreeMap<String, String>();
    transient List<ConceptSimilarityService.SimilarityMetricEnum> metrics = new ArrayList<ConceptSimilarityService.SimilarityMetricEnum>();
    transient String[] metricSelectCorpusIC;
    transient String[] metricSelectIntrinsicIC;
    transient String[] metricSelectTaxonomy;
    transient SemanticSimRegistryBean semanticSimRegistryBean;
    transient List<SimilarityEntry> similarityList;
    transient Map<ConceptSimilarityService.SimilarityMetricEnum, Double> similarityMap = new HashMap<ConceptSimilarityService.SimilarityMetricEnum, Double>();
    transient SimilarityInfo simInfo = new SimilarityInfo();

    public ConceptLookupBean getConcept1() {
        return this.concept1;
    }

    public ConceptLookupBean getConcept2() {
        return this.concept2;
    }

    public String getConceptGraphName() {
        return this.conceptGraphName;
    }

    public String getConceptPairText() {
        return this.conceptPairText;
    }

    public String getCorpusLcsTerm() {
        return this.corpusLcsTerm;
    }

    public String getExportType() {
        return this.exportType;
    }

    public String getIntrinsicLcsTerm() {
        return this.intrinsicLcsTerm;
    }

    public Map<String, String> getLcsPathMap() {
        return this.lcsPathMap;
    }

    public List<ConceptSimilarityService.SimilarityMetricEnum> getMetrics() {
        return this.metrics;
    }

    public String[] getMetricSelectCorpusIC() {
        return this.metricSelectCorpusIC;
    }

    public String[] getMetricSelectIntrinsicIC() {
        return this.metricSelectIntrinsicIC;
    }

    public String[] getMetricSelectTaxonomy() {
        return this.metricSelectTaxonomy;
    }

    public SemanticSimRegistryBean getSemanticSimRegistryBean() {
        return this.semanticSimRegistryBean;
    }

    public List<SimilarityEntry> getSimilarityList() {
        return this.similarityList;
    }

    public Map<ConceptSimilarityService.SimilarityMetricEnum, Double> getSimilarityMap() {
        return this.similarityMap;
    }

    public SimilarityInfo getSimInfo() {
        return this.simInfo;
    }

    private void initMetrics() {
        this.metrics.clear();
        for (String metric : this.metricSelectTaxonomy) {
            this.metrics.add(ConceptSimilarityService.SimilarityMetricEnum.valueOf((String)metric));
        }
        for (String metric : this.metricSelectCorpusIC) {
            this.metrics.add(ConceptSimilarityService.SimilarityMetricEnum.valueOf((String)metric));
        }
        for (String metric : this.metricSelectIntrinsicIC) {
            this.metrics.add(ConceptSimilarityService.SimilarityMetricEnum.valueOf((String)metric));
        }
    }

    private void reset() {
        ConceptSearchService searchSvc = ((SemanticSimServiceBean)this.getSemanticSimRegistryBean().getSemanticSimServiceMap().get(this.conceptGraphName)).getConceptSearchService();
        this.concept1.reset();
        this.concept1.setUmlsFirstWordService(searchSvc);
        this.concept2.reset();
        this.concept2.setUmlsFirstWordService(searchSvc);
        this.simInfo = null;
        this.intrinsicLcsTerm = null;
        this.corpusLcsTerm = null;
        this.metrics.clear();
        if (this.similarityMap != null) {
            this.similarityMap.clear();
        }
    }

    public void resetListen(ActionEvent event) {
        this.reset();
    }

    public void setConcept1(ConceptLookupBean concept1) {
        this.concept1 = concept1;
    }

    public void setConcept2(ConceptLookupBean concept2) {
        this.concept2 = concept2;
    }

    public void setConceptGraphName(String conceptGraphName) {
        this.conceptGraphName = conceptGraphName;
    }

    public void setConceptPairText(String conceptPairText) {
        this.conceptPairText = conceptPairText;
    }

    public void setCorpusLcsTerm(String corpusLcsTerm) {
        this.corpusLcsTerm = corpusLcsTerm;
    }

    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    public void setIntrinsicLcsTerm(String intrinsicLcsTerm) {
        this.intrinsicLcsTerm = intrinsicLcsTerm;
    }

    public void setLcsPathMap(Map<String, String> lcsPathMap) {
        this.lcsPathMap = lcsPathMap;
    }

    public void setMetrics(List<ConceptSimilarityService.SimilarityMetricEnum> metrics) {
        this.metrics = metrics;
    }

    public void setMetricSelectCorpusIC(String[] metricSelectCorpusIC) {
        this.metricSelectCorpusIC = metricSelectCorpusIC;
    }

    public void setMetricSelectIntrinsicIC(String[] metricSelectIntrinsicIC) {
        this.metricSelectIntrinsicIC = metricSelectIntrinsicIC;
    }

    public void setMetricSelectTaxonomy(String[] metricSelectTaxonomy) {
        this.metricSelectTaxonomy = metricSelectTaxonomy;
    }

    public void setSemanticSimRegistryBean(SemanticSimRegistryBean semanticSimRegistryBean) {
        this.semanticSimRegistryBean = semanticSimRegistryBean;
        if (semanticSimRegistryBean != null) {
            this.conceptGraphName = semanticSimRegistryBean.getDefaultConceptGraphName();
        }
    }

    public void setSimilarityList(List<SimilarityEntry> similarityList) {
        this.similarityList = similarityList;
    }

    public void setSimilarityMap(Map<ConceptSimilarityService.SimilarityMetricEnum, Double> similarityMap) {
        this.similarityMap = similarityMap;
    }

    public void setSimInfo(SimilarityInfo simInfo) {
        this.simInfo = simInfo;
    }

    public void simListen(ActionEvent event) {
        if (this.concept1.getCurrentCUI() != null && this.concept2.getCurrentCUI() != null) {
            this.concept1.setSearchCUI(this.concept1.getCurrentCUI());
            this.concept2.setSearchCUI(this.concept2.getCurrentCUI());
            this.initMetrics();
            ConceptSimilarityService simSvc = ((SemanticSimServiceBean)this.getSemanticSimRegistryBean().getSemanticSimServiceMap().get(this.conceptGraphName)).getConceptSimilarityService();
            ConceptSearchService searchSvc = ((SemanticSimServiceBean)this.getSemanticSimRegistryBean().getSemanticSimServiceMap().get(this.conceptGraphName)).getConceptSearchService();
            ConceptPairSimilarity csim = simSvc.similarity(this.metrics, this.concept1.getSearchCUI().getConceptId(), this.concept2.getSearchCUI().getConceptId(), null, true);
            this.simInfo = csim.getSimilarityInfo();
            this.similarityMap = this.toSimMap(csim);
            this.lcsPathMap.clear();
            if (this.simInfo.getLcsPaths() != null) {
                for (LCSPath lcsPath : this.simInfo.getLcsPaths()) {
                    String lcs = lcsPath.getLcs();
                    this.lcsPathMap.put(lcs, lcsPath.toString());
                }
            }
            this.corpusLcsTerm = this.simInfo.getCorpusLcs() != null ? searchSvc.getTermByConceptId(this.simInfo.getCorpusLcs()) : null;
            this.intrinsicLcsTerm = this.simInfo.getIntrinsicLcs() != null ? searchSvc.getTermByConceptId(this.simInfo.getIntrinsicLcs()) : null;
        }
    }

    public void simMultiListen(ActionEvent event) throws IOException {
        this.similarityList = new ArrayList<SimilarityEntry>();
        if (this.conceptPairText != null) {
            this.initMetrics();
            ArrayList<ConceptPair> conceptPairs = new ArrayList<ConceptPair>();
            BufferedReader r = new BufferedReader(new StringReader(this.conceptPairText));
            String line = null;
            while ((line = r.readLine()) != null) {
                String[] concepts = line.split(",|\\s");
                if (concepts.length != 2) continue;
                ConceptPair p = new ConceptPair();
                p.setConcept1(concepts[0]);
                p.setConcept2(concepts[1]);
                conceptPairs.add(p);
            }
            ConceptSimilarityService simSvc = ((SemanticSimServiceBean)this.getSemanticSimRegistryBean().getSemanticSimServiceMap().get(this.conceptGraphName)).getConceptSimilarityService();
            List similarities = simSvc.similarity(conceptPairs, this.metrics, null, false);
            for (int i = 0; i < conceptPairs.size(); ++i) {
                SimilarityEntry e = new SimilarityEntry();
                e.setConceptPair((ConceptPair)conceptPairs.get(i));
                e.setSimilarityMap(this.toSimMap((ConceptPairSimilarity)similarities.get(i)));
                this.similarityList.add(e);
            }
        }
    }

    private Map<ConceptSimilarityService.SimilarityMetricEnum, Double> toSimMap(ConceptPairSimilarity csim) {
        TreeMap<ConceptSimilarityService.SimilarityMetricEnum, Double> simMap = new TreeMap<ConceptSimilarityService.SimilarityMetricEnum, Double>();
        for (int i = 0; i < this.metrics.size(); ++i) {
            simMap.put(this.metrics.get(i), (Double)csim.getSimilarities().get(i));
        }
        return simMap;
    }

    public void updateConceptGraph(ValueChangeEvent event) {
        String newConceptGraphName = (String)event.getNewValue();
        if (!newConceptGraphName.equals(this.conceptGraphName)) {
            this.conceptGraphName = newConceptGraphName;
            this.reset();
        }
    }

    public static class SimilarityEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ConceptPair conceptPair;
        private Map<ConceptSimilarityService.SimilarityMetricEnum, Double> similarityMap;

        public ConceptPair getConceptPair() {
            return this.conceptPair;
        }

        public Map<ConceptSimilarityService.SimilarityMetricEnum, Double> getSimilarityMap() {
            return this.similarityMap;
        }

        public void setConceptPair(ConceptPair conceptPair) {
            this.conceptPair = conceptPair;
        }

        public void setSimilarityMap(Map<ConceptSimilarityService.SimilarityMetricEnum, Double> similarityMap) {
            this.similarityMap = similarityMap;
        }
    }
}

