/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.web.search;

import com.icesoft.faces.component.selectinputtext.SelectInputText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.web.search.ConceptFirstWord;
import org.apache.ctakes.ytex.web.search.ConceptSearchService;
import org.apache.ctakes.ytex.web.search.DocumentSearchResult;
import org.apache.ctakes.ytex.web.search.DocumentSearchService;

public class SemanticSearchBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SemanticSearchBean.class);
    private transient ConceptSearchService umlsFirstWordService;
    private transient DocumentSearchService documentSearchService;
    private Date dateFrom;
    private Date dateTo;
    private Integer patientId;
    private Boolean negationStatus;
    private ConceptFirstWord currentCUI = new ConceptFirstWord();
    private ConceptFirstWord searchCUI = new ConceptFirstWord();
    private List<SelectItem> matchesList = new ArrayList<SelectItem>();
    private List<DocumentSearchResult> searchResultList = new ArrayList<DocumentSearchResult>();
    public static Comparator<Object> umlsFirstWordComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof ConceptFirstWord ? SemanticSearchBean.formatUMLSFirstWord((ConceptFirstWord)o1) : o1.toString();
            String s2 = o2 instanceof ConceptFirstWord ? SemanticSearchBean.formatUMLSFirstWord((ConceptFirstWord)o2) : o2.toString();
            return s1.compareTo(s2);
        }
    };

    public ConceptSearchService getUmlsFirstWordService() {
        return this.umlsFirstWordService;
    }

    public void setUmlsFirstWordService(ConceptSearchService umlsFirstWordService) {
        this.umlsFirstWordService = umlsFirstWordService;
    }

    public DocumentSearchService getDocumentSearchService() {
        return this.documentSearchService;
    }

    public void setDocumentSearchService(DocumentSearchService documentSearchService) {
        this.documentSearchService = documentSearchService;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public Integer getPatientId() {
        return this.patientId;
    }

    public void setPatientId(Integer patientId) {
        if (patientId != null && patientId != 0) {
            this.patientId = patientId;
        }
    }

    public Boolean getNegationStatus() {
        return this.negationStatus;
    }

    public void setNegationStatus(Boolean negationStatus) {
        this.negationStatus = negationStatus;
    }

    public ConceptFirstWord getSearchCUI() {
        return this.searchCUI;
    }

    public void setSearchCUI(ConceptFirstWord searchCUI) {
        this.searchCUI = searchCUI;
    }

    public List<DocumentSearchResult> getSearchResultList() {
        return this.searchResultList;
    }

    public void setSearchResultList(List<DocumentSearchResult> searchResultList) {
        this.searchResultList = searchResultList;
    }

    public void searchListen(ActionEvent event) {
        this.searchCUI = this.currentCUI;
        if (this.currentCUI != null) {
            this.searchResultList = this.getNegationStatus() != null || this.getPatientId() != null || this.getDateFrom() != null || this.getDateTo() != null ? this.documentSearchService.extendedSearch(this.currentCUI.getConceptId(), null, this.getDateFrom(), this.getDateTo(), this.getPatientId(), this.getNegationStatus()) : this.documentSearchService.searchByCui(this.currentCUI.getConceptId());
            if (log.isDebugEnabled()) {
                log.debug(this.searchResultList);
            }
        }
    }

    public void resetListen(ActionEvent event) {
        this.setNegationStatus(null);
        this.setDateFrom(null);
        this.setDateTo(null);
        this.setPatientId(null);
        this.setSearchResultList(null);
        this.searchCUI = null;
    }

    public void updateList(ValueChangeEvent event) {
        this.setMatches(event);
        if (event.getComponent() instanceof SelectInputText) {
            SelectInputText autoComplete = (SelectInputText)event.getComponent();
            if (autoComplete.getSelectedItem() != null) {
                this.currentCUI = (ConceptFirstWord)autoComplete.getSelectedItem().getValue();
            } else {
                ConceptFirstWord tempCUI = this.getMatch(autoComplete.getValue().toString());
                if (tempCUI != null) {
                    this.currentCUI = tempCUI;
                }
            }
        }
    }

    public ConceptFirstWord getCurrentCUI() {
        return this.currentCUI;
    }

    public List<SelectItem> getList() {
        return this.matchesList;
    }

    public static String formatUMLSFirstWord(ConceptFirstWord fword) {
        return fword.getText() + " [" + fword.getConceptId() + ']';
    }

    public static ConceptFirstWord extractUMLSFirstWord(String fword) {
        String[] tokens = fword.split("[|]");
        ConceptFirstWord umlsFWord = new ConceptFirstWord();
        if (tokens.length > 1) {
            String cui = tokens[tokens.length - 1];
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < tokens.length - 1; ++i) {
                builder.append(tokens[i]);
            }
            String text = builder.toString();
            umlsFWord.setConceptId(cui);
            umlsFWord.setText(text);
        }
        return umlsFWord;
    }

    private ConceptFirstWord getMatch(String value) {
        ConceptFirstWord result = null;
        if (this.matchesList != null) {
            for (SelectItem si : this.matchesList) {
                if (!value.equals(si.getLabel())) continue;
                return (ConceptFirstWord)si.getValue();
            }
        }
        return result;
    }

    private void setMatches(ValueChangeEvent event) {
        Object searchWord = event.getNewValue();
        String searchString = searchWord instanceof SelectItem ? ((SelectItem)searchWord).getLabel() : searchWord.toString();
        if (searchString != null && searchString.length() > 2) {
            List<ConceptFirstWord> cuis = this.umlsFirstWordService.getConceptByFirstWord(searchString);
            this.matchesList = new ArrayList<SelectItem>(cuis.size());
            for (ConceptFirstWord cui : cuis) {
                this.matchesList.add(new SelectItem((Object)cui, SemanticSearchBean.formatUMLSFirstWord(cui)));
            }
        }
    }
}

